package com.atlassian.plugin.webresource.condition;

import com.atlassian.plugin.webresource.url.DefaultUrlBuilder;
import com.atlassian.plugin.webresource.url.UrlBuilder;
import com.google.common.collect.ImmutableMap;

import java.util.HashMap;
import java.util.Map;

/**
 * Caches results of Conditions per request.
 *
 * @since v 3.3.0
 */
public class ConditionsCache
{
    private Map<DecoratingCondition, Boolean> shouldDisplayImmediateCache = new HashMap<DecoratingCondition, Boolean>();
    private Map<DecoratingCondition, DefaultUrlBuilder> addToUrlCache = new HashMap<DecoratingCondition, DefaultUrlBuilder>();

    public Boolean shouldDisplayImmediate(DecoratingCondition condition)
    {
        Boolean result = shouldDisplayImmediateCache.get(condition);
        if (result == null)
        {
            result = condition.shouldDisplayImmediate(ImmutableMap.<String, Object>of());
            shouldDisplayImmediateCache.put(condition, result);
        }
        return result;
    }

    public void addToUrl(DecoratingCondition condition, DefaultUrlBuilder urlBuilder)
    {
        DefaultUrlBuilder result = addToUrlCache.get(condition);
        if (result == null)
        {
            result = new DefaultUrlBuilder();
            condition.addToUrl(result);
            addToUrlCache.put(condition, result);
        }
        result.addTo(urlBuilder);
    }
}