package com.atlassian.plugin.webresource;

import com.atlassian.annotations.Internal;
import org.apache.commons.lang.StringUtils;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * WARNING Do not use it, it will be removed in the next version!
 *
 * Web Resource.
 *
 * @since 3.3
 */
@Internal
public class Bundle
{
    protected Config.Snapshot snapshot;
    private final String key;
    private final String version;
    private final boolean isTransformable;
    private final List<String> dependencies;
    private final Date updatedAt;

    public Bundle(Config.Snapshot snapshot, String key, List<String> dependencies, Date updatedAt, String version,
            boolean isTransformable)
    {
        this.snapshot = snapshot;
        this.key = key;
        this.dependencies = dependencies;
        this.updatedAt = updatedAt;
        this.version = version;
        this.isTransformable = isTransformable;
    }

    public String getKey()
    {
        return key;
    }

    /**
     * List of dependencies.
     *
     * @return list of Web Resources keys.
     */
    public List<String> getDependencies()
    {
        return dependencies;
    }

    public Date getUpdatedAt()
    {
        return updatedAt;
    }

    public String getVersion()
    {
        return version;
    }

    public boolean isTransformable()
    {
        return isTransformable;
    }

    public boolean isCdnSupported()
    {
        return !hasLegacyConditions() && !snapshot.webResourcesWithLegacyTransformers.contains(this);
    }

    public boolean hasLegacyConditions()
    {
        return snapshot.webResourcesWithLegacyConditions.contains(this);
    }

    protected Config.Snapshot getSnapshot()
    {
        return snapshot;
    }

    // Workaround to provide `friend` visibility scope, so only WebResource would be able to access `cache
    // .getCachedResources`.
    public static class Access
    {
        private Access()
        {
        }
    }

    private static Access ACCESS = new Access();

    /**
     * Get Resources of this Web Resource.
     */
    public Map<String, Resource> getResources(RequestCache cache)
    {
        Map<String, Resource> resources = cache.getCachedResources(ACCESS).get(this);
        if (resources == null)
        {
            resources = snapshot.config.getResourcesWithoutCache(this);
            cache.getCachedResources(ACCESS).put(this, resources);
        }
        return resources;
    }

    @Override
    public boolean equals(Object o)
    {
        if (this == o)
        {
            return true;
        }
        if ((o == null) || (getClass() != o.getClass()))
        {
            return false;
        }
        return key.equals(((Bundle) o).key);
    }

    @Override
    public int hashCode()
    {
        return key.hashCode();
    }

    @Override
    public String toString()
    {
        return "{" + key + (dependencies.isEmpty() ? "" : (", dependencies: " + StringUtils.join(dependencies, ","
                + ""))) + "}";
    }
}