/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.url;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UrlParameters {
    private static final UrlParameters EMPTY_CDN_OK = new UrlParameters(true);
    private static final UrlParameters EMPTY_CDN_TAINTED = new UrlParameters(false);
    private final List<String> hashes;
    private final Map<String, String> queryString;
    private final boolean isCdnSupported;

    public static UrlParameters of(boolean isCdnSupported) {
        return isCdnSupported ? EMPTY_CDN_OK : EMPTY_CDN_TAINTED;
    }

    public static UrlParameters of(boolean isCdnSupported, List<String> hashes, Map<String, String> queryString) {
        return new UrlParameters(isCdnSupported, hashes, queryString);
    }

    private UrlParameters(boolean isCdnSupported) {
        this(isCdnSupported, Collections.emptyList(), Collections.emptyMap());
    }

    private UrlParameters(boolean isCdnSupported, List<String> hashes, Map<String, String> queryString) {
        this.isCdnSupported = isCdnSupported;
        this.hashes = ImmutableList.copyOf(hashes);
        this.queryString = ImmutableMap.copyOf(queryString);
    }

    public List<String> allHashes() {
        return this.hashes;
    }

    public Map<String, String> toQueryString() {
        return this.queryString;
    }

    public boolean isCdnSupported() {
        return this.isCdnSupported;
    }

    public UrlParameters merge(UrlParameters other) {
        HashMap mergedQueryString = Maps.newHashMap(this.queryString);
        mergedQueryString.putAll(other.queryString);
        ImmutableList mergedHashes = ImmutableList.copyOf((Iterable)Iterables.concat(this.hashes, other.hashes));
        return new UrlParameters(this.isCdnSupported && other.isCdnSupported(), (List<String>)mergedHashes, mergedQueryString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UrlParameters that = (UrlParameters)o;
        if (this.isCdnSupported != that.isCdnSupported) {
            return false;
        }
        if (!((Object)this.hashes).equals(that.hashes)) {
            return false;
        }
        return ((Object)this.queryString).equals(that.queryString);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{((Object)this.hashes).hashCode(), ((Object)this.queryString).hashCode(), Boolean.valueOf(this.isCdnSupported).hashCode()});
    }
}

