/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.condition;

import com.atlassian.plugin.webresource.condition.DecoratingCondition;
import com.atlassian.plugin.webresource.url.DefaultUrlBuilder;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;

public class ConditionsCache {
    private Map<DecoratingCondition, Boolean> shouldDisplayImmediateCache = new HashMap<DecoratingCondition, Boolean>();
    private Map<DecoratingCondition, DefaultUrlBuilder> addToUrlCache = new HashMap<DecoratingCondition, DefaultUrlBuilder>();

    public Boolean shouldDisplayImmediate(DecoratingCondition condition) {
        Boolean result = this.shouldDisplayImmediateCache.get(condition);
        if (result == null) {
            result = condition.shouldDisplayImmediate((Map<String, Object>)ImmutableMap.of());
            this.shouldDisplayImmediateCache.put(condition, result);
        }
        return result;
    }

    public void addToUrl(DecoratingCondition condition, DefaultUrlBuilder urlBuilder) {
        DefaultUrlBuilder result = this.addToUrlCache.get(condition);
        if (result == null) {
            result = new DefaultUrlBuilder();
            condition.addToUrl(result);
            this.addToUrlCache.put(condition, result);
        }
        result.addTo(urlBuilder);
    }
}

