/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.webresource.Content;
import com.atlassian.plugin.webresource.Helpers;
import com.atlassian.plugin.webresource.QueryParams;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.atlassian.plugin.webresource.transformer.ContentTransformerModuleDescriptor;
import com.atlassian.plugin.webresource.transformer.TransformableResource;
import com.atlassian.plugin.webresource.transformer.TransformerCache;
import com.atlassian.plugin.webresource.transformer.TransformerParameters;
import com.atlassian.plugin.webresource.transformer.UrlReadingContentTransformer;
import com.atlassian.plugin.webresource.transformer.UrlReadingWebResourceTransformer;
import com.atlassian.plugin.webresource.transformer.UrlReadingWebResourceTransformerModuleDescriptor;
import com.atlassian.plugin.webresource.transformer.WebResourceTransformerModuleDescriptor;
import com.atlassian.plugin.webresource.url.UrlBuilder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebResourceTransformation {
    private final String extension;
    private final String type;
    private final Map<String, Element> transformerElements;
    private final Iterable<String> transformerKeys;
    private Logger log = LoggerFactory.getLogger(WebResourceTransformation.class);

    public WebResourceTransformation(Element element) {
        Validate.notNull((Object)element.attribute("extension"));
        this.type = element.attributeValue("extension");
        this.extension = "." + this.type;
        LinkedHashMap<String, Element> transformers = new LinkedHashMap<String, Element>();
        for (Element transformElement : element.elements("transformer")) {
            transformers.put(transformElement.attributeValue("key"), transformElement);
        }
        this.transformerElements = Collections.unmodifiableMap(transformers);
        this.transformerKeys = this.transformerElements.keySet();
    }

    public boolean matches(ResourceLocation location) {
        String loc = location.getLocation();
        if (loc == null || "".equals(loc.trim())) {
            loc = location.getName();
        }
        return loc.endsWith(this.extension);
    }

    public boolean matches(String location) {
        return location.equals(this.type);
    }

    public void addTransformParameters(TransformerCache transformerCache, WebResourceModuleDescriptor webResourceModuleDescriptor, UrlBuilder urlBuilder) {
        for (String key : this.transformerKeys) {
            AbstractModuleDescriptor descriptor;
            Object descriptorAsObject = transformerCache.getDescriptor(key);
            if (descriptorAsObject == null) continue;
            if (descriptorAsObject instanceof UrlReadingWebResourceTransformerModuleDescriptor) {
                descriptor = (UrlReadingWebResourceTransformerModuleDescriptor)((Object)descriptorAsObject);
                descriptor.getModule().makeUrlBuilder(TransformerParameters.of(webResourceModuleDescriptor)).addToUrl(urlBuilder);
                continue;
            }
            if (descriptorAsObject instanceof ContentTransformerModuleDescriptor) {
                descriptor = (ContentTransformerModuleDescriptor)((Object)descriptorAsObject);
                descriptor.getModule().makeUrlBuilder(TransformerParameters.of(webResourceModuleDescriptor)).addToUrl(urlBuilder);
                continue;
            }
            if (descriptorAsObject instanceof WebResourceTransformerModuleDescriptor) continue;
            throw new RuntimeException("invalid usage, transformer descriptor expected but got " + descriptorAsObject);
        }
    }

    public boolean containsOnlyPureUrlReadingTransformers(TransformerCache transformerCache) {
        for (String key : this.transformerKeys) {
            Object descriptorAsObject = transformerCache.getDescriptor(key);
            if (descriptorAsObject == null || !(descriptorAsObject instanceof WebResourceTransformerModuleDescriptor)) continue;
            return false;
        }
        return true;
    }

    public Iterable<WebResourceTransformerModuleDescriptor> getDeprecatedTransformers(TransformerCache transformerCache) {
        LinkedList<WebResourceTransformerModuleDescriptor> deprecatedTransformers = new LinkedList<WebResourceTransformerModuleDescriptor>();
        for (String key : this.transformerKeys) {
            Object descriptorAsObject = transformerCache.getDescriptor(key);
            if (descriptorAsObject == null || !(descriptorAsObject instanceof WebResourceTransformerModuleDescriptor)) continue;
            deprecatedTransformers.add((WebResourceTransformerModuleDescriptor)((Object)descriptorAsObject));
        }
        return deprecatedTransformers;
    }

    public Content transform(TransformerCache transformerCache, Content content, ResourceLocation resourceLocation, String pluginKey, String filePath, String webResourceKey, QueryParams params, String sourceUrl) {
        Content lastContent = content;
        for (String transformerKey : this.transformerKeys) {
            Object descriptorAsObject = transformerCache.getDescriptor(transformerKey);
            if (descriptorAsObject != null) {
                AbstractModuleDescriptor descriptor;
                if (descriptorAsObject instanceof ContentTransformerModuleDescriptor) {
                    descriptor = (ContentTransformerModuleDescriptor)((Object)descriptorAsObject);
                    TransformerParameters transformerParameters = new TransformerParameters(pluginKey, webResourceKey);
                    UrlReadingContentTransformer transformer = descriptor.getModule().makeResourceTransformer(transformerParameters);
                    lastContent = transformer.transform(lastContent, resourceLocation, params, sourceUrl);
                    continue;
                }
                if (descriptorAsObject instanceof UrlReadingWebResourceTransformerModuleDescriptor) {
                    descriptor = (UrlReadingWebResourceTransformerModuleDescriptor)((Object)descriptorAsObject);
                    TransformableResource transformableResource = new TransformableResource(resourceLocation, filePath, Helpers.asDownloadableResource(lastContent));
                    TransformerParameters transformerParameters = new TransformerParameters(pluginKey, webResourceKey);
                    UrlReadingWebResourceTransformer transformer = descriptor.getModule().makeResourceTransformer(transformerParameters);
                    lastContent = Helpers.asContent(transformer.transform(transformableResource, params), null, true);
                    continue;
                }
                if (descriptorAsObject instanceof WebResourceTransformerModuleDescriptor) {
                    descriptor = (WebResourceTransformerModuleDescriptor)((Object)descriptorAsObject);
                    lastContent = Helpers.asContent(descriptor.getModule().transform(this.transformerElements.get(transformerKey), resourceLocation, filePath, Helpers.asDownloadableResource(lastContent)), null, true);
                    continue;
                }
                throw new RuntimeException("invalid usage, transformer descriptor expected but got " + descriptorAsObject);
            }
            this.log.warn("Web resource transformer {} not found for resource {}, skipping", (Object)transformerKey, (Object)resourceLocation.getName());
        }
        return lastContent;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " with " + this.transformerKeys.toString() + " transformers";
    }
}

