/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.annotations.Internal;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.servlet.ContentTypeResolver;
import com.atlassian.plugin.servlet.DownloadException;
import com.atlassian.plugin.servlet.DownloadableClasspathResource;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.servlet.DownloadableWebResource;
import com.atlassian.plugin.servlet.ServletContextFactory;
import com.atlassian.plugin.util.PluginUtils;
import com.atlassian.plugin.util.validation.ValidationException;
import com.atlassian.plugin.webresource.Bundle;
import com.atlassian.plugin.webresource.Content;
import com.atlassian.plugin.webresource.ContentImpl;
import com.atlassian.plugin.webresource.DefaultResourceDependencyResolver;
import com.atlassian.plugin.webresource.LocationContentAnnotator;
import com.atlassian.plugin.webresource.PluginResourceContainer;
import com.atlassian.plugin.webresource.Resource;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.ResourceContentAnnotator;
import com.atlassian.plugin.webresource.ResourceUtils;
import com.atlassian.plugin.webresource.SemicolonResourceContentAnnotator;
import com.atlassian.plugin.webresource.TryCatchJsResourceContentAnnotator;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResource;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.atlassian.plugin.webresource.WebResourceTransformation;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.plugin.webresource.condition.DecoratingCondition;
import com.atlassian.plugin.webresource.support.http.BaseRouter;
import com.atlassian.plugin.webresource.transformer.StaticTransformers;
import com.atlassian.plugin.webresource.transformer.TransformerCache;
import com.atlassian.plugin.webresource.util.HashBuilder;
import com.atlassian.sourcemap.SourceMap;
import com.atlassian.sourcemap.Util;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

@Internal
public class Config {
    public static final String RESOURCE_SOURCE_PARAM = "source";
    public static final String CONTEXT_RESOURCE_PREFIX = "_context";
    public static final String RESOURCE_BATCH_PARAM = "batch";
    private static final String RESOURCE_DOWNLOAD_TYPE = "download";
    private final WebResourceIntegration integration;
    private final ResourceBatchingConfiguration batchingConfiguration;
    private final WebResourceUrlProvider urlProvider;
    private ContentTypeResolver contentTypeResolver;
    private final ServletContextFactory servletContextFactory;
    private final StaticTransformers staticTransformers;
    private final TransformerCache transformerCache;

    public Config(ResourceBatchingConfiguration batchingConfiguration, WebResourceIntegration integration, WebResourceUrlProvider urlProvider, ServletContextFactory servletContextFactory, StaticTransformers staticTransformers, TransformerCache transformerCache) {
        this.batchingConfiguration = batchingConfiguration;
        this.integration = integration;
        this.urlProvider = urlProvider;
        this.servletContextFactory = servletContextFactory;
        this.staticTransformers = staticTransformers;
        this.transformerCache = transformerCache;
    }

    public void setContentTypeResolver(ContentTypeResolver contentTypeResolver) {
        if (this.contentTypeResolver != null) {
            throw new RuntimeException("content type resolver already set!");
        }
        this.contentTypeResolver = contentTypeResolver;
    }

    public boolean isCacheEnabled() {
        return !Boolean.getBoolean(PluginUtils.WEBRESOURCE_DISABLE_FILE_CACHE) || Boolean.getBoolean("atlassian.dev.mode");
    }

    public int getCacheSize() {
        return Integer.getInteger(PluginUtils.WEBRESOURCE_FILE_CACHE_SIZE, 1000);
    }

    public File getCacheDirectory() {
        return this.integration.getTemporaryDirectory();
    }

    public boolean isSourceMapEnabledFor(String typeOrContentType) {
        return this.batchingConfiguration.isSourceMapEnabled() && Util.isSourceMapSupportedBy((String)typeOrContentType);
    }

    public boolean isCdnEnabled() {
        return null != this.integration.getCDNStrategy() && this.integration.getCDNStrategy().supportsCdn();
    }

    public String getCurrentLocale() {
        return this.integration.getStaticResourceLocale();
    }

    public String getBaseUrl() {
        return this.getBaseUrl(true);
    }

    public String getBaseUrl(boolean isAbsolute) {
        try {
            return BaseRouter.joinWithSlashWithoutEmpty(this.urlProvider.getBaseUrl(isAbsolute ? UrlMode.ABSOLUTE : UrlMode.RELATIVE), RESOURCE_DOWNLOAD_TYPE);
        }
        catch (AssertionError e) {
            if (isAbsolute && ((Throwable)((Object)e)).getMessage().contains("Unsupported URLMode")) {
                return this.getBaseUrl(false);
            }
            throw e;
        }
    }

    public String getResourceUrlPrefix(String hash, String version, boolean isAbsolute) {
        return this.urlProvider.getStaticResourcePrefix(hash, version, isAbsolute ? UrlMode.ABSOLUTE : UrlMode.RELATIVE) + "/" + RESOURCE_DOWNLOAD_TYPE;
    }

    public String getResourceCdnPrefix(String url) {
        return this.integration.getCDNStrategy().transformRelativeUrl(url);
    }

    public String getContentType(String path) {
        return this.contentTypeResolver.getContentType(path);
    }

    public ResourceContentAnnotator[] getContentAnnotators(String type) {
        if ("js".equals(type)) {
            if (this.batchingConfiguration.isJavaScriptTryCatchWrappingEnabled()) {
                return new ResourceContentAnnotator[]{new SemicolonResourceContentAnnotator(), new TryCatchJsResourceContentAnnotator(), new LocationContentAnnotator()};
            }
            return new ResourceContentAnnotator[]{new SemicolonResourceContentAnnotator(), new LocationContentAnnotator()};
        }
        if ("css".equals(type)) {
            return new ResourceContentAnnotator[]{new LocationContentAnnotator()};
        }
        return new ResourceContentAnnotator[0];
    }

    public StaticTransformers getStaticTransformers() {
        return this.staticTransformers;
    }

    protected void ensureNoLegacyStuff(Snapshot snapshot) {
        if (this.integration.forbidCondition1AndTransformer1()) {
            LinkedList<String> resourcesWithLegacyConditions = new LinkedList<String>();
            for (Bundle bundle : snapshot.webResourcesWithLegacyConditions) {
                if (this.integration.allowedCondition1Keys().contains(bundle.getKey())) continue;
                resourcesWithLegacyConditions.add(bundle.getKey());
            }
            LinkedList<String> resourcesWithLegacyTransformers = new LinkedList<String>();
            for (Bundle bundle : snapshot.webResourcesWithLegacyTransformers) {
                if (this.integration.allowedTransform1Keys().contains(bundle.getKey())) continue;
                resourcesWithLegacyTransformers.add(bundle.getKey());
            }
            if (resourcesWithLegacyConditions.size() > 0 || resourcesWithLegacyTransformers.size() > 0) {
                ArrayList<String> messages = new ArrayList<String>();
                if (resourcesWithLegacyConditions.size() > 0) {
                    messages.add("legacy conditions: \"" + Joiner.on((String)"\", \"").join(resourcesWithLegacyConditions) + "\"");
                }
                if (resourcesWithLegacyTransformers.size() > 0) {
                    messages.add("legacy transformers: \"" + Joiner.on((String)"\", \"").join(resourcesWithLegacyTransformers) + "\"");
                }
                throw new ValidationException("there are web resources with " + Joiner.on((String)", and ").join(messages), (List)ImmutableList.of());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Bundle> getWebResourcesWithoutCache() {
        Snapshot snapshot = new Snapshot(this);
        HashMap<String, Bundle> bundles = new HashMap<String, Bundle>();
        class IntermediaryContextData {
            public List<String> dependencies = new ArrayList<String>();
            public Date updatedAt;
            public String version = "";

            IntermediaryContextData() {
            }
        }
        HashMap<String, IntermediaryContextData> intermediaryContexts = new HashMap<String, IntermediaryContextData>();
        List webResourceDescriptors = this.integration.getPluginAccessor().getEnabledModuleDescriptorsByClass(WebResourceModuleDescriptor.class);
        for (WebResourceModuleDescriptor webResourceModuleDescriptor : webResourceDescriptors) {
            Plugin plugin = webResourceModuleDescriptor.getPlugin();
            Date updatedAt = plugin.getDateLoaded() == null ? new Date() : plugin.getDateLoaded();
            String completeKey = webResourceModuleDescriptor.getCompleteKey();
            DecoratingCondition condition = webResourceModuleDescriptor.getCondition();
            boolean hasLegacyConditions = condition != null && !condition.canEncodeStateIntoUrl();
            List<WebResourceTransformation> transformations = webResourceModuleDescriptor.getTransformations();
            boolean hasLegacyTransformers = false;
            for (WebResourceTransformation transformation : transformations) {
                if (transformation.containsOnlyPureUrlReadingTransformers(this.transformerCache)) continue;
                hasLegacyTransformers = true;
                break;
            }
            WebResource bundle = new WebResource(snapshot, completeKey, webResourceModuleDescriptor.getDependencies(), updatedAt, plugin.getPluginInformation().getVersion(), true);
            if (hasLegacyConditions) {
                snapshot.webResourcesWithLegacyConditions.add(bundle);
            }
            if (hasLegacyTransformers) {
                snapshot.webResourcesWithLegacyTransformers.add(bundle);
            }
            bundles.put(completeKey, bundle);
            for (String context : webResourceModuleDescriptor.getContexts()) {
                if (context.equals(completeKey)) continue;
                String contextResourceKey = "_context:" + context;
                IntermediaryContextData contextData = (IntermediaryContextData)intermediaryContexts.get(contextResourceKey);
                if (contextData == null) {
                    contextData = new IntermediaryContextData();
                    intermediaryContexts.put(contextResourceKey, contextData);
                }
                contextData.dependencies.add(completeKey);
                if (contextData.updatedAt == null || contextData.updatedAt.before(updatedAt)) {
                    contextData.updatedAt = updatedAt;
                }
                contextData.version = HashBuilder.buildHash(contextData.version, bundle.getVersion());
            }
            snapshot.webResourcesCondition.put(bundle, condition);
            snapshot.webResourcesTransformations.put(bundle, transformations);
        }
        for (Map.Entry entry : intermediaryContexts.entrySet()) {
            String contextResourceKey = (String)entry.getKey();
            IntermediaryContextData contextData = (IntermediaryContextData)entry.getValue();
            bundles.put(contextResourceKey, new Bundle(snapshot, contextResourceKey, contextData.dependencies, contextData.updatedAt, contextData.version, true));
        }
        if (this.batchingConfiguration.isSuperBatchingEnabled()) {
            void var6_10;
            List<String> dependencies = this.batchingConfiguration.getSuperBatchModuleCompleteKeys();
            Date date = new Date(0L);
            String version = "";
            for (String completeKey : dependencies) {
                Bundle superbatch = (Bundle)bundles.get(completeKey);
                if (superbatch == null) continue;
                if (superbatch.getUpdatedAt().after((Date)var6_10)) {
                    Date date2 = superbatch.getUpdatedAt();
                }
                version = HashBuilder.buildHash(version, superbatch.getVersion());
            }
            String superbatchKey = "_context:" + DefaultResourceDependencyResolver.IMPLICIT_CONTEXT_NAME;
            bundles.put(superbatchKey, new Bundle(snapshot, superbatchKey, dependencies, (Date)var6_10, version, true));
        }
        this.ensureNoLegacyStuff(snapshot);
        return bundles;
    }

    public Map<String, Resource> getResourcesWithoutCache(Bundle bundle) {
        String completeKey = bundle.getKey();
        ModuleDescriptor moduleDescriptor = this.integration.getPluginAccessor().getEnabledPluginModule(completeKey);
        if (moduleDescriptor == null) {
            return new HashMap<String, Resource>();
        }
        if (!(moduleDescriptor instanceof WebResourceModuleDescriptor)) {
            throw new RuntimeException("module " + completeKey + "isn't the web resource!");
        }
        WebResourceModuleDescriptor webResourceDescriptor = (WebResourceModuleDescriptor)moduleDescriptor;
        LinkedHashMap<String, Resource> resources = new LinkedHashMap<String, Resource>();
        for (ResourceDescriptor resourceDescriptor : webResourceDescriptor.getResourceDescriptors()) {
            if (!RESOURCE_DOWNLOAD_TYPE.equals(resourceDescriptor.getType())) continue;
            ResourceLocation resourceLocation = resourceDescriptor.getResourceLocationForName(null);
            Resource resource = this.buildResource(bundle, resourceLocation);
            resources.put(resource.getName(), resource);
        }
        return resources;
    }

    public Content getContentFor(Resource resource) {
        boolean isMinificationEnabled;
        Plugin plugin;
        ResourceLocation resourceLocation = resource.getResourceLocation();
        if (resource.getKey().contains(":")) {
            ModuleDescriptor moduleDescriptor = this.integration.getPluginAccessor().getEnabledPluginModule(resource.getKey());
            plugin = (Plugin)Preconditions.checkNotNull((Object)moduleDescriptor.getPlugin());
            isMinificationEnabled = moduleDescriptor instanceof WebResourceModuleDescriptor ? !((WebResourceModuleDescriptor)moduleDescriptor).isDisableMinification() : true;
        } else {
            plugin = (Plugin)Preconditions.checkNotNull((Object)this.integration.getPluginAccessor().getEnabledPlugin(resource.getKey()));
            isMinificationEnabled = true;
        }
        String sourceParam = resourceLocation.getParameter(RESOURCE_SOURCE_PARAM);
        Object downloadableResource = "webContextStatic".equalsIgnoreCase(sourceParam) ? new DownloadableWebResource(plugin, resourceLocation, resource.getFilePath(), this.servletContextFactory.getServletContext(), !isMinificationEnabled) : new DownloadableClasspathResource(plugin, resourceLocation, resource.getFilePath());
        return new ContentImpl(resource.getContentType(), false, (DownloadableResource)downloadableResource){
            final /* synthetic */ DownloadableResource val$downloadableResource;
            {
                this.val$downloadableResource = downloadableResource;
                super(x0, x1);
            }

            @Override
            public SourceMap writeTo(OutputStream out, boolean isSourceMapEnabled) {
                try {
                    this.val$downloadableResource.streamResource(out);
                    return null;
                }
                catch (DownloadException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    protected Resource buildResource(Bundle bundle, ResourceLocation resourceLocation) {
        String sourceParam = resourceLocation.getParameter(RESOURCE_SOURCE_PARAM);
        String type = ResourceUtils.getType(!StringUtils.isEmpty((String)resourceLocation.getName()) ? resourceLocation.getName() : resourceLocation.getName());
        boolean isRedirect = "webContext".equalsIgnoreCase(sourceParam);
        boolean isBatchable = !isRedirect && !"false".equalsIgnoreCase(resourceLocation.getParameter(RESOURCE_BATCH_PARAM));
        boolean isCacheable = !"false".equalsIgnoreCase((String)resourceLocation.getParams().get("cache"));
        Resource resource = new Resource(bundle, resourceLocation, type, isBatchable, isRedirect, isCacheable);
        return resource;
    }

    public Resource getModuleResource(String completeKey, String name) {
        if (!Config.isWebResourceKey(completeKey)) {
            return null;
        }
        ModuleDescriptor moduleDescriptor = this.integration.getPluginAccessor().getEnabledPluginModule(completeKey);
        if (moduleDescriptor == null) {
            return null;
        }
        ResourceLocation resourceLocation = moduleDescriptor.getResourceLocation(RESOURCE_DOWNLOAD_TYPE, name);
        if (resourceLocation == null) {
            return null;
        }
        Plugin plugin = moduleDescriptor.getPlugin();
        Date updatedAt = plugin.getDateLoaded() == null ? new Date() : plugin.getDateLoaded();
        PluginResourceContainer resourceContainer = new PluginResourceContainer(new Snapshot(this), completeKey, updatedAt, plugin.getPluginInformation().getVersion());
        return this.buildResource(resourceContainer, resourceLocation);
    }

    public Resource getPluginResource(String pluginKey, String name) {
        Plugin plugin = this.integration.getPluginAccessor().getPlugin(pluginKey);
        if (plugin == null) {
            return null;
        }
        ResourceLocation resourceLocation = plugin.getResourceLocation(RESOURCE_DOWNLOAD_TYPE, name);
        if (resourceLocation == null) {
            return null;
        }
        PluginResourceContainer resourceContainer = new PluginResourceContainer(new Snapshot(this), pluginKey, plugin.getDateLoaded(), plugin.getPluginInformation().getVersion());
        Resource resource = this.buildResource(resourceContainer, resourceLocation);
        return resource;
    }

    public static boolean isWebResourceKey(String completeKey) {
        return completeKey.contains(":");
    }

    public int partialHashCode() {
        return this.integration.getSuperBatchVersion().hashCode();
    }

    @Deprecated
    WebResourceIntegration getIntegration() {
        return this.integration;
    }

    @Deprecated
    TransformerCache getTransformerCache() {
        return this.transformerCache;
    }

    protected static class Snapshot {
        final Config config;
        final Map<Bundle, List<WebResourceTransformation>> webResourcesTransformations = new HashMap<Bundle, List<WebResourceTransformation>>();
        final Map<Bundle, DecoratingCondition> webResourcesCondition = new HashMap<Bundle, DecoratingCondition>();
        final Set<Bundle> webResourcesWithLegacyConditions = new HashSet<Bundle>();
        final Set<Bundle> webResourcesWithLegacyTransformers = new HashSet<Bundle>();

        Snapshot(Config config) {
            this.config = config;
        }
    }
}

