/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.transformer;

import com.atlassian.fugue.Pair;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import com.atlassian.plugin.webresource.transformer.UrlReadingWebResourceTransformerModuleDescriptor;
import com.atlassian.plugin.webresource.transformer.WebResourceTransformerModuleDescriptor;
import com.atlassian.util.concurrent.ResettableLazyReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TransformerCache {
    private final ResettableLazyReference<Pair<Map<String, UrlReadingWebResourceTransformerModuleDescriptor>, Map<String, WebResourceTransformerModuleDescriptor>>> lazyReferenceTransformerCache;

    public TransformerCache(PluginEventManager pluginEventManager, final PluginAccessor pluginAccessor) {
        this.lazyReferenceTransformerCache = new ResettableLazyReference<Pair<Map<String, UrlReadingWebResourceTransformerModuleDescriptor>, Map<String, WebResourceTransformerModuleDescriptor>>>(){

            protected Pair<Map<String, UrlReadingWebResourceTransformerModuleDescriptor>, Map<String, WebResourceTransformerModuleDescriptor>> create() {
                List descriptors = pluginAccessor.getEnabledModuleDescriptorsByClass(UrlReadingWebResourceTransformerModuleDescriptor.class);
                HashMap<String, UrlReadingWebResourceTransformerModuleDescriptor> keysToDescriptors = new HashMap<String, UrlReadingWebResourceTransformerModuleDescriptor>();
                for (UrlReadingWebResourceTransformerModuleDescriptor descriptor : descriptors) {
                    String aliasKey;
                    if (!keysToDescriptors.containsKey(descriptor.getKey())) {
                        keysToDescriptors.put(descriptor.getKey(), descriptor);
                    }
                    if ((aliasKey = descriptor.getAliasKey()) == null || keysToDescriptors.containsKey(aliasKey)) continue;
                    keysToDescriptors.put(aliasKey, descriptor);
                }
                List deprecatedDescriptors = pluginAccessor.getEnabledModuleDescriptorsByClass(WebResourceTransformerModuleDescriptor.class);
                HashMap<String, WebResourceTransformerModuleDescriptor> keysToDeprecatedDescriptors = new HashMap<String, WebResourceTransformerModuleDescriptor>();
                for (WebResourceTransformerModuleDescriptor descriptor : deprecatedDescriptors) {
                    if (keysToDescriptors.containsKey(descriptor.getKey()) || keysToDeprecatedDescriptors.containsKey(descriptor.getKey())) continue;
                    keysToDeprecatedDescriptors.put(descriptor.getKey(), descriptor);
                }
                return new Pair(keysToDescriptors, keysToDeprecatedDescriptors);
            }
        };
        pluginEventManager.register((Object)this);
    }

    @PluginEventListener
    public void onPluginDisabled(PluginDisabledEvent event) {
        this.lazyReferenceTransformerCache.reset();
    }

    @PluginEventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        this.lazyReferenceTransformerCache.reset();
    }

    @PluginEventListener
    public void onPluginModuleEnabled(PluginModuleEnabledEvent event) {
        this.lazyReferenceTransformerCache.reset();
    }

    @PluginEventListener
    public void onPluginModuleDisabled(PluginModuleDisabledEvent event) {
        this.lazyReferenceTransformerCache.reset();
    }

    public UrlReadingWebResourceTransformerModuleDescriptor getDescriptor(String transformerKey) {
        return (UrlReadingWebResourceTransformerModuleDescriptor)((Object)((Map)((Pair)this.lazyReferenceTransformerCache.get()).left()).get(transformerKey));
    }

    public WebResourceTransformerModuleDescriptor getDeprecatedDescriptor(String transformerKey) {
        return (WebResourceTransformerModuleDescriptor)((Object)((Map)((Pair)this.lazyReferenceTransformerCache.get()).right()).get(transformerKey));
    }
}

