/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.webresource.SinglePluginResource;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.plugin.webresource.url.CDNSupport;
import org.apache.commons.lang.StringUtils;

public class WebResourceUrlProviderImpl
implements WebResourceUrlProvider {
    static final String STATIC_RESOURCE_PREFIX = "s";
    static final String STATIC_RESOURCE_SUFFIX = "_";
    private final WebResourceIntegration webResourceIntegration;

    public WebResourceUrlProviderImpl(WebResourceIntegration webResourceIntegration) {
        this.webResourceIntegration = webResourceIntegration;
    }

    @Override
    public String getStaticResourcePrefix(UrlMode urlMode) {
        String lang = this.makeLocaleHashPath();
        return this.webResourceIntegration.getBaseUrl(urlMode) + "/" + STATIC_RESOURCE_PREFIX + "/" + lang + this.webResourceIntegration.getSystemBuildNumber() + "/" + this.webResourceIntegration.getSystemCounter() + "/" + STATIC_RESOURCE_SUFFIX;
    }

    private String makeLocaleHashPath() {
        String lang = this.webResourceIntegration.getStaticResourceLocale();
        return null == lang ? "" : lang + "/";
    }

    @Override
    public String getStaticResourcePrefix(String resourceCounter, UrlMode urlMode) {
        String lang = this.makeLocaleHashPath();
        return this.webResourceIntegration.getBaseUrl(urlMode) + "/" + STATIC_RESOURCE_PREFIX + "/" + lang + this.webResourceIntegration.getSystemBuildNumber() + "/" + this.webResourceIntegration.getSystemCounter() + "/" + resourceCounter + "/" + STATIC_RESOURCE_SUFFIX;
    }

    @Override
    public String getStaticResourcePrefix(String contributedHash, String resourceCounter, UrlMode urlMode) {
        String lang = this.makeLocaleHashPath();
        contributedHash = StringUtils.isNotBlank((String)contributedHash) ? contributedHash + "/" : "";
        return this.webResourceIntegration.getBaseUrl(urlMode) + "/" + STATIC_RESOURCE_PREFIX + "/" + contributedHash + lang + this.webResourceIntegration.getSystemBuildNumber() + "/" + this.webResourceIntegration.getSystemCounter() + "/" + resourceCounter + "/" + STATIC_RESOURCE_SUFFIX;
    }

    @Override
    public String getStaticPluginResourceUrl(String moduleCompleteKey, String resourceName, UrlMode urlMode) {
        ModuleDescriptor moduleDescriptor = this.webResourceIntegration.getPluginAccessor().getEnabledPluginModule(moduleCompleteKey);
        if (moduleDescriptor == null) {
            return null;
        }
        return this.getStaticPluginResourceUrl(moduleDescriptor, resourceName, urlMode);
    }

    public String getStaticPluginResourceUrl(ModuleDescriptor moduleDescriptor, String resourceName, UrlMode urlMode) {
        PluginInformation pluginInfo = moduleDescriptor.getPlugin().getPluginInformation();
        String pluginVersion = pluginInfo != null ? pluginInfo.getVersion() : "unknown";
        String staticUrlPrefix = this.getStaticResourcePrefix(pluginVersion, urlMode);
        return staticUrlPrefix + this.getResourceUrl(moduleDescriptor.getCompleteKey(), resourceName);
    }

    @Override
    public String getResourceUrl(String moduleCompleteKey, String resourceName) {
        return new SinglePluginResource(resourceName, moduleCompleteKey, false, CDNSupport.OK).getUrl();
    }

    @Override
    public String getBaseUrl() {
        return this.webResourceIntegration.getBaseUrl();
    }

    @Override
    public String getBaseUrl(UrlMode urlMode) {
        return this.webResourceIntegration.getBaseUrl(urlMode);
    }
}

