/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.webresource.ContextBatch;
import com.atlassian.plugin.webresource.ContextBatchOperations;
import com.atlassian.plugin.webresource.DefaultWebResourceFilter;
import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.ResourceDependencyResolver;
import com.atlassian.plugin.webresource.WebResourceFilter;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextBatchBuilder {
    private static final Logger log = LoggerFactory.getLogger(ContextBatchBuilder.class);
    private final PluginResourceLocator pluginResourceLocator;
    private final ResourceDependencyResolver dependencyResolver;
    private final ResourceBatchingConfiguration batchingConfiguration;
    private final List<String> allIncludedResources = new ArrayList<String>();
    private final Set<String> skippedResources = new HashSet<String>();

    public ContextBatchBuilder(PluginResourceLocator pluginResourceLocator, ResourceDependencyResolver dependencyResolver, ResourceBatchingConfiguration batchingConfiguration) {
        this.pluginResourceLocator = pluginResourceLocator;
        this.dependencyResolver = dependencyResolver;
        this.batchingConfiguration = batchingConfiguration;
    }

    public Iterable<PluginResource> build(List<String> includedContexts, Set<String> excludedContexts) {
        return this.build(includedContexts, excludedContexts, DefaultWebResourceFilter.INSTANCE);
    }

    public Iterable<PluginResource> build(List<String> includedContexts, Set<String> excludedContexts, WebResourceFilter filter) {
        if (this.batchingConfiguration.isContextBatchingEnabled()) {
            return this.buildBatched(includedContexts, excludedContexts, filter);
        }
        return this.getUnbatchedResources(includedContexts, excludedContexts, filter);
    }

    private Iterable<PluginResource> buildBatched(List<String> includedContexts, Set<String> excludedContexts, WebResourceFilter filter) {
        HashSet<String> conditionalIncludedResources = new HashSet<String>();
        WebResourceKeysToContextBatches includedBatches = WebResourceKeysToContextBatches.create(includedContexts, this.dependencyResolver, this.pluginResourceLocator, this.batchingConfiguration, filter, conditionalIncludedResources);
        WebResourceKeysToContextBatches excludedBatches = null;
        if (excludedContexts != null && !Iterables.isEmpty(excludedContexts)) {
            excludedBatches = WebResourceKeysToContextBatches.create(excludedContexts, this.dependencyResolver, this.pluginResourceLocator, this.batchingConfiguration, filter, new HashSet<String>());
        }
        this.skippedResources.addAll(includedBatches.getSkippedResources());
        ArrayList<ContextBatch> batches = new ArrayList<ContextBatch>();
        ArrayList<ContextBatch> batchesToProcess = new ArrayList<ContextBatch>(includedBatches.getContextBatches());
        ContextBatchOperations contextBatchOperations = new ContextBatchOperations(this.pluginResourceLocator, filter);
        while (!batchesToProcess.isEmpty()) {
            String resourceKey;
            ContextBatch contextBatch = (ContextBatch)batchesToProcess.remove(0);
            HashSet<ContextBatch> alreadyProcessedBatches = new HashSet<ContextBatch>();
            alreadyProcessedBatches.add(contextBatch);
            Iterator<WebResourceModuleDescriptor> resourceIterator = contextBatch.getResources().iterator();
            while (resourceIterator.hasNext()) {
                WebResourceModuleDescriptor contextResource = resourceIterator.next();
                resourceKey = contextResource.getCompleteKey();
                List<ContextBatch> additionalContexts = includedBatches.getAdditionalContextsForResourceKey(resourceKey, alreadyProcessedBatches);
                if (!CollectionUtils.isNotEmpty(additionalContexts)) continue;
                if (log.isDebugEnabled()) {
                    for (ContextBatch additional : additionalContexts) {
                        log.debug("Context: {} shares a resource with {}: {}", (Object[])new String[]{contextBatch.getKey(), additional.getKey(), contextResource.getCompleteKey()});
                    }
                }
                ArrayList<ContextBatch> contextsToMerge = new ArrayList<ContextBatch>(1 + additionalContexts.size());
                contextsToMerge.add(contextBatch);
                contextsToMerge.addAll(additionalContexts);
                contextBatch = contextBatchOperations.merge(contextsToMerge);
                batchesToProcess.removeAll(additionalContexts);
                alreadyProcessedBatches.addAll(additionalContexts);
                resourceIterator = contextBatch.getResources().iterator();
            }
            if (excludedBatches != null) {
                for (WebResourceModuleDescriptor contextResource : contextBatch.getResources()) {
                    resourceKey = contextResource.getCompleteKey();
                    List<ContextBatch> excludeContexts = excludedBatches.getContextsForResourceKey(resourceKey);
                    if (excludeContexts.isEmpty()) continue;
                    contextBatch = contextBatchOperations.subtract(contextBatch, excludeContexts);
                }
                this.skippedResources.removeAll(excludedBatches.getSkippedResources());
            }
            if (excludedBatches == null || Iterables.size(contextBatch.getResources()) != 0) {
                Iterables.addAll(this.allIncludedResources, contextBatch.getResourceKeys());
                batches.add(contextBatch);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("The context batch {} contains no resources so will be dropped.", (Object)contextBatch.getKey());
        }
        final boolean resplitMergedBatches = this.batchingConfiguration.resplitMergedContextBatchesForThisRequest();
        return Iterables.concat((Iterable)Iterables.transform(batches, (Function)new Function<ContextBatch, Iterable<PluginResource>>(){

            public Iterable<PluginResource> apply(ContextBatch batch) {
                return batch.buildPluginResources(resplitMergedBatches);
            }
        }));
    }

    private Iterable<PluginResource> getUnbatchedResources(Iterable<String> includedContexts, Iterable<String> excludedContexts, WebResourceFilter filter) {
        HashSet<String> excludedResourceKeys = new HashSet<String>();
        HashSet<String> excludedSkippedResources = new HashSet<String>();
        if (excludedContexts != null && Iterables.size(excludedContexts) > 0) {
            for (String context : excludedContexts) {
                Iterable<WebResourceModuleDescriptor> contextResources = this.dependencyResolver.getDependenciesInContext(context, excludedSkippedResources);
                for (WebResourceModuleDescriptor contextResource : contextResources) {
                    excludedResourceKeys.add(contextResource.getCompleteKey());
                }
            }
        }
        LinkedHashSet<PluginResource> includedResources = new LinkedHashSet<PluginResource>();
        HashSet<String> includedSkippedResources = new HashSet<String>();
        for (String context : includedContexts) {
            Iterable<WebResourceModuleDescriptor> contextResources = this.dependencyResolver.getDependenciesInContext(context, includedSkippedResources);
            for (WebResourceModuleDescriptor contextResource : contextResources) {
                String completeKey = contextResource.getCompleteKey();
                if (excludedResourceKeys.contains(completeKey) || this.allIncludedResources.contains(completeKey)) continue;
                List<PluginResource> moduleResources = this.pluginResourceLocator.getPluginResources(contextResource.getCompleteKey());
                for (PluginResource moduleResource : moduleResources) {
                    if (!filter.matches(moduleResource.getResourceName())) continue;
                    includedResources.add(moduleResource);
                }
                this.allIncludedResources.add(contextResource.getCompleteKey());
            }
        }
        includedSkippedResources.removeAll(excludedSkippedResources);
        this.skippedResources.addAll(includedSkippedResources);
        return includedResources;
    }

    public Iterable<String> getAllIncludedResources() {
        return this.allIncludedResources;
    }

    public Iterable<String> getSkippedResources() {
        return this.skippedResources;
    }

    private static class WebResourceKeysToContextBatches {
        private final Map<String, List<ContextBatch>> resourceToContextBatches;
        private final List<ContextBatch> knownBatches;
        private final Set<String> skippedResources;

        static WebResourceKeysToContextBatches create(Iterable<String> contexts, ResourceDependencyResolver dependencyResolver, PluginResourceLocator pluginResourceLocator, ResourceBatchingConfiguration batchingConfiguration, WebResourceFilter filter, Set<String> conditionalResources) {
            HashMap<String, List<ContextBatch>> resourceKeyToContext = new HashMap<String, List<ContextBatch>>();
            ArrayList<ContextBatch> batches = new ArrayList<ContextBatch>();
            HashSet<String> skippedResources = new HashSet<String>();
            for (String context : contexts) {
                Iterable<WebResourceModuleDescriptor> dependencies = dependencyResolver.getDependenciesInContext(context, skippedResources);
                ContextBatch batch = new ContextBatch(context, dependencies, batchingConfiguration.isSuperBatchingEnabled());
                for (WebResourceModuleDescriptor moduleDescriptor : dependencies) {
                    String key = moduleDescriptor.getCompleteKey();
                    boolean matchedPluginResource = false;
                    for (PluginResource pluginResource : pluginResourceLocator.getPluginResources(moduleDescriptor.getCompleteKey())) {
                        if (!filter.matches(pluginResource.getResourceName())) continue;
                        batch.addResourceType(pluginResource);
                        matchedPluginResource = true;
                    }
                    if (filter == DefaultWebResourceFilter.INSTANCE && !moduleDescriptor.getDataProviders().isEmpty()) {
                        matchedPluginResource = true;
                    }
                    if (!matchedPluginResource) continue;
                    if (!resourceKeyToContext.containsKey(key)) {
                        resourceKeyToContext.put(key, new ArrayList());
                    }
                    ((List)resourceKeyToContext.get(key)).add(batch);
                    if (batches.contains(batch)) continue;
                    batches.add(batch);
                }
            }
            return new WebResourceKeysToContextBatches(resourceKeyToContext, batches, skippedResources);
        }

        private WebResourceKeysToContextBatches(Map<String, List<ContextBatch>> resourceKeyToContext, List<ContextBatch> allBatches, Set<String> skippedResources) {
            this.resourceToContextBatches = resourceKeyToContext;
            this.knownBatches = allBatches;
            this.skippedResources = skippedResources;
        }

        List<ContextBatch> getContextsForResourceKey(String key) {
            return this.getAdditionalContextsForResourceKey(key, null);
        }

        List<ContextBatch> getAdditionalContextsForResourceKey(String key, Collection<ContextBatch> knownContexts) {
            List<ContextBatch> allContexts = this.resourceToContextBatches.get(key);
            if (CollectionUtils.isEmpty(allContexts)) {
                return Collections.emptyList();
            }
            LinkedHashSet<ContextBatch> contexts = new LinkedHashSet<ContextBatch>(allContexts);
            if (CollectionUtils.isNotEmpty(knownContexts)) {
                contexts.removeAll(knownContexts);
            }
            return new ArrayList<ContextBatch>(contexts);
        }

        List<ContextBatch> getContextBatches() {
            return new ArrayList<ContextBatch>(this.knownBatches);
        }

        public Set<String> getSkippedResources() {
            return this.skippedResources;
        }
    }
}

