/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.cache.filecache.FileCache;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.AbstractBatchResourceBuilder;
import com.atlassian.plugin.webresource.BatchDownloadableResource;
import com.atlassian.plugin.webresource.DownloadableResourceFinder;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.ResourceUtils;
import com.atlassian.plugin.webresource.UrlParseException;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.plugin.webresource.cache.CacheHandle;
import com.atlassian.plugin.webresource.cache.FileCacheKey;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SingleBatchDownloadableResourceBuilder
extends AbstractBatchResourceBuilder {
    private static final Logger log = LoggerFactory.getLogger(SingleBatchDownloadableResourceBuilder.class);

    public SingleBatchDownloadableResourceBuilder(PluginAccessor pluginAccessor, WebResourceUrlProvider webResourceUrlProvider, DownloadableResourceFinder resourceFinder, FileCache<FileCacheKey> cache, ResourceBatchingConfiguration resourceBatchingConfiguration) {
        super(pluginAccessor, webResourceUrlProvider, resourceFinder, cache, resourceBatchingConfiguration);
    }

    @Override
    public boolean matches(String path) {
        return path.indexOf("/download/batch") > -1;
    }

    @Override
    public DownloadableResource parse(String path, Map<String, String> params) throws UrlParseException {
        String type = ResourceUtils.getType(path);
        int startIndex = path.indexOf("/download/batch") + "/download/batch".length() + 1;
        String typeAndModuleKey = path.substring(startIndex);
        String[] parts = typeAndModuleKey.split("/", 2);
        if (parts.length < 2) {
            throw new UrlParseException("Could not parse invalid batch resource url: " + path);
        }
        String moduleKey = parts[0];
        String resourceName = parts[1];
        BatchDownloadableResource batchResource = new BatchDownloadableResource(moduleKey, type, params, this.resolve(moduleKey, type, params), CacheHandle.Builder.forRequest(this.cache, "singlebatch", path, params), this.resourceBatchingConfiguration);
        if (log.isDebugEnabled()) {
            log.debug(batchResource.toString());
        }
        if (batchResource.isEmpty()) {
            return this.getResourceFinder().find(moduleKey, resourceName, params);
        }
        return batchResource;
    }
}

