/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.webresource.AbstractPluginResource;
import com.atlassian.plugin.webresource.BatchedWebResourceDescriptor;
import com.atlassian.plugin.webresource.ContextBatchOperations;
import com.atlassian.plugin.webresource.ResourceKey;
import com.atlassian.plugin.webresource.ResourceUtils;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.url.UrlParameters;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ContextBatchPluginResource
extends AbstractPluginResource {
    static final String REMOVE_SB_URL_PREFIX = new String("/download/contextbatch/");
    static final String INCLUDE_SB_URL_PREFIX = new String("/download/contextbatch2/");
    private final ResourceKey resource;
    private final String key;
    private final String versionHash;
    private final List<String> contexts;
    private final Iterable<String> excludedContexts;
    private boolean removeSuperResources;

    ContextBatchPluginResource(String key, List<String> contexts, Iterable<String> excludedContexts, String versionHash, String type, UrlParameters urlParams, Map<String, String> params, Set<BatchedWebResourceDescriptor> batchedWebResourceDescriptor, boolean removeSuperResources) {
        super(urlParams, params, Collections.unmodifiableSet(batchedWebResourceDescriptor));
        this.resource = ResourceKey.Builder.batch(type);
        this.key = key;
        this.versionHash = versionHash;
        this.contexts = contexts;
        this.excludedContexts = excludedContexts;
        this.removeSuperResources = removeSuperResources;
    }

    Iterable<String> getContexts() {
        return this.contexts;
    }

    public Iterable<String> getExcludedContexts() {
        return this.excludedContexts;
    }

    @Override
    public String getUrl() {
        String prefix = this.removeSuperResources ? REMOVE_SB_URL_PREFIX : INCLUDE_SB_URL_PREFIX;
        StringBuilder buf = new StringBuilder(prefix.length() + 20);
        buf.append(prefix).append(this.getType()).append("/").append(this.key).append("/").append(this.getResourceName());
        ResourceUtils.addParamsToUrl(buf, this.getParams(), this.getBatchableParams());
        return buf.toString();
    }

    @Override
    public String getVersion(WebResourceIntegration integration) {
        return this.versionHash;
    }

    @Override
    public String getType() {
        return this.resource.suffix();
    }

    @Override
    public boolean isCacheSupported() {
        return true;
    }

    @Override
    public String getResourceName() {
        return this.resource.name();
    }

    @Override
    public String getModuleCompleteKey() {
        return "contextbatch-" + this.resource.name();
    }

    public Collection<ContextBatchPluginResource> splitIntoParts() {
        if (this.contexts.size() <= 1) {
            return Collections.singletonList(this);
        }
        LinkedList<ContextBatchPluginResource> result = new LinkedList<ContextBatchPluginResource>();
        ArrayList<String> furtherExcludes = new ArrayList<String>();
        for (String ctx : this.contexts) {
            Iterable totalExcludes = Iterables.concat(this.excludedContexts, furtherExcludes);
            List<String> newContexts = Collections.singletonList(ctx);
            String newKey = ContextBatchOperations.buildContextKey(newContexts, totalExcludes);
            result.add(new ContextBatchPluginResource(newKey, newContexts, totalExcludes, this.versionHash, this.getType(), this.urlParams, this.params, this.batchedWebResourceDescriptors, this.removeSuperResources));
            furtherExcludes.add(ctx);
        }
        return result;
    }

    public String toString() {
        return "[Context Batch type=" + this.getType() + ", params=" + this.params + "]";
    }
}

