/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.webresource.BatchedWebResourceDescriptor;
import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.plugin.webresource.url.CDNSupport;
import com.atlassian.plugin.webresource.url.NamedHash;
import com.atlassian.plugin.webresource.url.UrlParameters;
import com.atlassian.plugin.webresource.util.HashBuilder;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPluginResource
implements PluginResource {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPluginResource.class);
    protected final UrlParameters urlParams;
    protected final Map<String, String> params;
    protected final Set<BatchedWebResourceDescriptor> batchedWebResourceDescriptors;

    protected AbstractPluginResource(UrlParameters urlParams, Map<String, String> params, Set<BatchedWebResourceDescriptor> batchedWebResourceDescriptors) {
        this.urlParams = urlParams;
        this.params = ImmutableMap.copyOf(params);
        this.batchedWebResourceDescriptors = batchedWebResourceDescriptors;
    }

    @Override
    public UrlParameters getUrlParameters() {
        return this.urlParams;
    }

    @Override
    public CDNSupport supportsCdn() {
        return this.urlParams.supportsCdn();
    }

    @Override
    public List<NamedHash> getHashes() {
        return this.urlParams.allHashes();
    }

    @Override
    public Map<String, String> getParams() {
        return this.params;
    }

    @Override
    public Map<String, String> getBatchableParams() {
        return this.urlParams.toQueryString();
    }

    @Override
    public Set<BatchedWebResourceDescriptor> getBatchedWebResourceDescriptors() {
        return this.batchedWebResourceDescriptors;
    }

    @Override
    public String getStaticUrl(WebResourceIntegration webResourceIntegration, WebResourceUrlProvider webResourceUrlProvider, UrlMode urlMode) {
        String url;
        if (this.isCacheSupported()) {
            List hashes = Lists.transform(this.getHashes(), (Function)new Function<NamedHash, String>(){

                public String apply(@Nullable NamedHash namedHash) {
                    return namedHash.getHash();
                }
            });
            String contributedHash = HashBuilder.buildHash(hashes) + this.supportsCdn().hashSuffix();
            if (this.supportsCdn(webResourceIntegration)) {
                String relativeUrl = webResourceUrlProvider.getStaticResourcePrefix(contributedHash, this.getVersion(webResourceIntegration), UrlMode.RELATIVE) + this.getUrl();
                url = webResourceIntegration.getCDNStrategy().transformRelativeUrl(relativeUrl);
            } else {
                url = webResourceUrlProvider.getStaticResourcePrefix(contributedHash, this.getVersion(webResourceIntegration), urlMode) + this.getUrl();
            }
        } else {
            url = webResourceUrlProvider.getBaseUrl(urlMode) + this.getUrl();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Static hashes for url: {}", (Object)this.getUrl());
            for (NamedHash namedHash : this.getHashes()) {
                logger.debug("{}: {}", (Object)namedHash.getName(), (Object)namedHash.getHash());
            }
        }
        return url;
    }

    private boolean supportsCdn(WebResourceIntegration webResourceIntegration) {
        return CDNSupport.OK.equals((Object)this.supportsCdn()) && null != webResourceIntegration.getCDNStrategy() && webResourceIntegration.getCDNStrategy().supportsCdn();
    }
}

