/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.cache.filecache.FileCacheStreamProvider;
import com.atlassian.plugin.servlet.DownloadException;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.NewlineResourceContentAnnotator;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.ResourceContentAnnotator;
import com.atlassian.plugin.webresource.SemicolonResourceContentAnnotator;
import com.atlassian.plugin.webresource.TryCatchJsResourceContentAnnotator;
import com.atlassian.plugin.webresource.cache.CacheHandle;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBatchDownloadableResource
implements DownloadableResource {
    private static final Logger log = LoggerFactory.getLogger(AbstractBatchDownloadableResource.class);
    private static final NewlineResourceContentAnnotator newlineResourceContentAnnotator = new NewlineResourceContentAnnotator();
    private static final SemicolonResourceContentAnnotator semicolonResourceContentAnnotator = new SemicolonResourceContentAnnotator();
    private static final TryCatchJsResourceContentAnnotator tryCatchJsResourceContentAnnotator = new TryCatchJsResourceContentAnnotator();
    private static final ResourceContentAnnotator[] DEFAULT_ANNOTATORS = new ResourceContentAnnotator[]{newlineResourceContentAnnotator};
    private static final ResourceContentAnnotator[] DEFAULT_JS_ANNOTATORS = new ResourceContentAnnotator[]{newlineResourceContentAnnotator, semicolonResourceContentAnnotator};
    private static final ResourceContentAnnotator[] JS_WRAP_ANNOTATORS = new ResourceContentAnnotator[]{newlineResourceContentAnnotator, semicolonResourceContentAnnotator, tryCatchJsResourceContentAnnotator};
    private final String type;
    private final Map<String, String> params;
    private final Iterable<DownloadableResource> resources;
    private final CacheHandle cacher;
    private final ResourceContentAnnotator[] resourceContentAnnotators;

    AbstractBatchDownloadableResource(String type, Map<String, String> params, Iterable<DownloadableResource> resources, CacheHandle cacher, ResourceBatchingConfiguration resourceBatchingConfiguration) {
        this.type = type;
        this.params = ImmutableMap.copyOf(params);
        this.resources = resources;
        this.cacher = cacher;
        this.resourceContentAnnotators = this.getAnnotators(resourceBatchingConfiguration);
    }

    public boolean isEmpty() {
        return Iterables.isEmpty(this.resources);
    }

    public boolean isResourceModified(final HttpServletRequest request, final HttpServletResponse response) {
        return Iterables.any(this.resources, (Predicate)new Predicate<DownloadableResource>(){

            public boolean apply(DownloadableResource resource) {
                return resource.isResourceModified(request, response);
            }
        });
    }

    public void serveResource(HttpServletRequest request, HttpServletResponse response) throws DownloadException {
        ServletOutputStream out;
        log.debug("Start to serve batch {}", (Object)this);
        try {
            out = response.getOutputStream();
        }
        catch (IOException e) {
            throw new DownloadException((Exception)e);
        }
        this.streamResourceInternal((OutputStream)out, this.resourceContentAnnotators);
        log.debug("Finished serving batch {}", (Object)this);
    }

    public void streamResource(OutputStream originalOut) throws DownloadException {
        this.streamResourceInternal(originalOut, this.resourceContentAnnotators);
    }

    private void streamResourceInternal(OutputStream originalOut, final ResourceContentAnnotator[] annotators) throws DownloadException {
        FileCacheStreamProvider streamProvider = new FileCacheStreamProvider(){

            @Override
            public void writeStream(OutputStream dest) throws DownloadException {
                for (DownloadableResource resource : AbstractBatchDownloadableResource.this.resources) {
                    try {
                        AbstractBatchDownloadableResource.this.applyBeforeAnnotators(dest, annotators);
                        resource.streamResource(dest);
                        AbstractBatchDownloadableResource.this.applyAfterAnnotators(dest, annotators);
                    }
                    catch (IOException ex) {
                        throw new DownloadException((Exception)ex);
                    }
                }
            }
        };
        this.cacher.stream(originalOut, streamProvider);
    }

    public String getContentType() {
        String contentType = this.params.get("content-type");
        if (contentType != null) {
            return contentType;
        }
        return null;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public String getType() {
        return this.type;
    }

    private void applyBeforeAnnotators(OutputStream str, ResourceContentAnnotator[] annotators) throws IOException {
        for (ResourceContentAnnotator annotator : annotators) {
            log.debug("Applying before annotator {}", (Object)annotator.getClass().getSimpleName());
            annotator.before(str);
            log.debug("Finished applying before annotator {}", (Object)annotator.getClass().getSimpleName());
        }
    }

    private void applyAfterAnnotators(OutputStream str, ResourceContentAnnotator[] annotators) throws IOException {
        for (int i = annotators.length - 1; i >= 0; --i) {
            log.debug("Applying after annotator {}", (Object)annotators[i].getClass().getSimpleName());
            annotators[i].after(str);
            log.debug("Finished applying after annotator {}", (Object)annotators[i].getClass().getSimpleName());
        }
    }

    private ResourceContentAnnotator[] getAnnotators(ResourceBatchingConfiguration batchingConfig) {
        if ("js".equals(this.getType())) {
            if (batchingConfig.isJavaScriptTryCatchWrappingEnabled()) {
                return JS_WRAP_ANNOTATORS;
            }
            return DEFAULT_JS_ANNOTATORS;
        }
        return DEFAULT_ANNOTATORS;
    }
}

