package com.atlassian.plugin.webresource.url;

/**
 * Named hash for contributing to urls for static resources. The name member is for logging & debugging only.
 * @since v3.0
 */
public class NamedHash
{
    final String name;
    final String hash;

    public NamedHash(String name, String hash)
    {
        this.name = name;
        this.hash = hash;
    }

    public String getName()
    {
        return name;
    }

    public String getHash()
    {
        return hash;
    }

    @Override
    public boolean equals(Object o)
    {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        NamedHash namedHash = (NamedHash) o;

        if (hash != null ? !hash.equals(namedHash.hash) : namedHash.hash != null) return false;
        if (name != null ? !name.equals(namedHash.name) : namedHash.name != null) return false;

        return true;
    }

    @Override
    public int hashCode()
    {
        int result = name != null ? name.hashCode() : 0;
        result = 31 * result + (hash != null ? hash.hashCode() : 0);
        return result;
    }
}
