package com.atlassian.plugin.webresource.cache;

import java.util.Arrays;
import java.util.List;
import java.util.SortedMap;

/**
 * @since v2.13
 */
public class FileCacheKey {
    private final SortedMap<String, String> params;
    private final List<String> rest;

    FileCacheKey(SortedMap<String, String> params, String... rest) {
        this.params = params;
        this.rest = Arrays.asList(rest);
    }

    @Override
    public String toString() {
        return "FileCacheKey{" +
                "params=" + params +
                ", rest=" + rest +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        FileCacheKey that = (FileCacheKey) o;

        if (!params.equals(that.params)) return false;
        if (!rest.equals(that.rest)) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = params.hashCode();
        result = 31 * result + rest.hashCode();
        return result;
    }
}
