package com.atlassian.plugin.webresource.assembler;

import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.webresource.api.assembler.resource.PluginUrlResource;

/**
 * Creates PluginUrlResource implementations
 * @since v3.0
 */
public class PluginUrlResourceFactory
{
    public static <T extends PluginUrlResource> T create(WebResourceIntegration webResourceIntegration,
        WebResourceUrlProvider webResourceUrlProvider, PluginResource pluginResource)
    {
        if ("js".equals(pluginResource.getType().toLowerCase()))
        {
            return (T) new DefaultPluginJsResource(webResourceIntegration, webResourceUrlProvider, pluginResource);
        }
        if ("css".equals(pluginResource.getType().toLowerCase()))
        {
            return (T) new DefaultPluginCssResource(webResourceIntegration, webResourceUrlProvider, pluginResource);
        }
        throw new RuntimeException("Cannot instantiate a PluginUrlResource for resource type: " + pluginResource.getType());
    }
}
