package com.atlassian.plugin.webresource;

import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.cache.CacheHandle;

import java.util.Map;

/**
 * Represents a batch of all resources that declare themselves as part of a given context(s).
 *
 * The URL for batch resources is /download/contextbatch/&lt;type>/&lt;contextname>/batch.&lt;type. The additional type part in the path
 * is simply there to make the number of path-parts identical with other resources, so relative URLs will still work
 * in CSS files.
 *
 * @since 2.9.0
 */
class ContextBatchDownloadableResource extends AbstractBatchDownloadableResource
{
    ContextBatchDownloadableResource(final String type, final Map<String, String> params,
                                     final Iterable<DownloadableResource> resources, final CacheHandle cacher,
                                     final ResourceBatchingConfiguration resourceBatchingConfiguration)
    {
        super(type, params, resources, cacher, resourceBatchingConfiguration);
    }

    @Override
    public String toString()
    {
        return "[Context Batch type=" + getType() + " params=" + getParams() + "]";
    }
}
