/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.assembler;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Set;

class InclusionState {
    private boolean superbatch;
    private Set<String> webresources;
    private Set<String> contexts;
    private Set<String> dataKeys;

    public InclusionState(boolean superbatch, Set<String> webresources, Set<String> contexts, Set<String> dataKeys) {
        Preconditions.checkNotNull(webresources);
        Preconditions.checkNotNull(contexts);
        Preconditions.checkNotNull(dataKeys);
        this.superbatch = superbatch;
        this.webresources = webresources;
        this.contexts = contexts;
        this.dataKeys = dataKeys;
    }

    public InclusionState copy() {
        return new InclusionState(this.superbatch, Sets.newHashSet(this.webresources), Sets.newHashSet(this.contexts), Sets.newHashSet(this.dataKeys));
    }

    public void reset(InclusionState that) {
        this.superbatch = that.superbatch;
        this.webresources = Sets.newHashSet(that.webresources);
        this.contexts = Sets.newHashSet(that.contexts);
        this.dataKeys = Sets.newHashSet(that.dataKeys);
    }

    public Set<String> getWebresources() {
        return this.webresources;
    }

    public Set<String> getContexts() {
        return this.contexts;
    }

    public Set<String> getDataKeys() {
        return this.dataKeys;
    }

    public boolean isSuperbatch() {
        return this.superbatch;
    }

    public void setSuperbatch(boolean superbatch) {
        this.superbatch = superbatch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InclusionState that = (InclusionState)o;
        if (this.superbatch != that.superbatch) {
            return false;
        }
        if (!this.contexts.equals(that.contexts)) {
            return false;
        }
        if (!this.dataKeys.equals(that.dataKeys)) {
            return false;
        }
        return this.webresources.equals(that.webresources);
    }

    public int hashCode() {
        int result = this.superbatch ? 1 : 0;
        result = 31 * result + this.webresources.hashCode();
        result = 31 * result + this.contexts.hashCode();
        result = 31 * result + this.dataKeys.hashCode();
        return result;
    }
}

