/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.AbstractTransformResource;
import com.atlassian.plugin.webresource.CssWebResource;
import com.atlassian.plugin.webresource.JavascriptWebResource;

public class SourceDescribingTransformResource
extends AbstractTransformResource {
    private final ModuleDescriptor<?> moduleDescriptor;
    private final ResourceDescriptor resourceDescriptor;

    static boolean matches(ResourceDescriptor resource) {
        return CssWebResource.FORMATTER.matches(resource.getName()) || JavascriptWebResource.FORMATTER.matches(resource.getName());
    }

    SourceDescribingTransformResource(ModuleDescriptor<?> moduleDescriptor, DownloadableResource originalResource, ResourceDescriptor resourceDescriptor) {
        super(originalResource);
        this.moduleDescriptor = moduleDescriptor;
        this.resourceDescriptor = resourceDescriptor;
    }

    @Override
    CharSequence transform(CharSequence originalContent) {
        String sourceDescriptor = String.format("/* module-key = '%s', location = '%s' */\n", this.moduleDescriptor.getCompleteKey(), this.resourceDescriptor.getLocation());
        return sourceDescriptor + originalContent;
    }

    public String toString() {
        return "Source Describing Transform Resource: originalResource: " + this.originalResource.toString();
    }
}

