/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.util.concurrent.LazyReference;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;

interface ResourceKey {
    public String key();

    public String name();

    public String suffix();

    public static class Equality {
        static boolean equal(ResourceKey left, ResourceKey right) {
            if (!left.key().equals(right.key())) {
                return false;
            }
            if (!left.name().equals(right.name())) {
                return false;
            }
            return left.suffix().equals(right.suffix());
        }

        public static int hash(ResourceKey resource) {
            int result = resource.key().hashCode();
            result = 31 * result + resource.name().hashCode();
            result = 31 * result + resource.suffix().hashCode();
            return result;
        }
    }

    public static class Builder {
        static final String DEFAULT_RESOURCE_NAME_PREFIX = "batch";
        static final Function<String, ResourceKey> BATCH_RESOURCE_KEY_CACHE = CacheBuilder.newBuilder().build(CacheLoader.from((Function)new Function<String, ResourceKey>(){

            public ResourceKey apply(String suffix) {
                return new Strict(Builder.DEFAULT_RESOURCE_NAME_PREFIX, "batch." + suffix, suffix);
            }
        }));

        static ResourceKey lazy(final String completeKey, final Supplier<String> suffix) {
            return new Lazy((Supplier<String>)Suppliers.ofInstance((Object)completeKey), (Supplier<String>)new LazyReference<String>(){

                protected String create() {
                    return completeKey + "." + (String)suffix.get();
                }
            }, suffix);
        }

        static ResourceKey batch(String suffix) {
            return (ResourceKey)BATCH_RESOURCE_KEY_CACHE.apply((Object)suffix);
        }
    }

    public static class Lazy
    implements ResourceKey {
        final Supplier<String> key;
        final Supplier<String> name;
        final Supplier<String> suffix;

        Lazy(Supplier<String> key, Supplier<String> name, Supplier<String> suffix) {
            this.key = (Supplier)Preconditions.checkNotNull(key);
            this.name = (Supplier)Preconditions.checkNotNull(name);
            this.suffix = (Supplier)Preconditions.checkNotNull(suffix);
        }

        @Override
        public String key() {
            return (String)this.key.get();
        }

        @Override
        public String name() {
            return (String)this.name.get();
        }

        @Override
        public String suffix() {
            return (String)this.suffix.get();
        }

        public boolean equals(Object o) {
            if (!(o instanceof ResourceKey)) {
                return false;
            }
            return Equality.equal(this, (ResourceKey)o);
        }

        public int hashCode() {
            return Equality.hash(this);
        }
    }

    public static class Strict
    implements ResourceKey {
        final String key;
        final String name;
        final String suffix;

        Strict(String key, String name, String suffix) {
            this.key = (String)Preconditions.checkNotNull((Object)key);
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.suffix = (String)Preconditions.checkNotNull((Object)suffix);
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String suffix() {
            return this.suffix;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ResourceKey)) {
                return false;
            }
            return Equality.equal(this, (ResourceKey)o);
        }

        public int hashCode() {
            return Equality.hash(this);
        }
    }
}

