/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.transformer;

import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.plugin.webresource.transformer.StaticTransformersSupplier;
import com.atlassian.plugin.webresource.transformer.WebResourceTransformerFactory;
import com.atlassian.plugin.webresource.transformer.WebResourceTransformerMatcher;
import com.atlassian.plugin.webresource.transformer.instance.RelativeUrlTransformerFactory;
import com.atlassian.plugin.webresource.transformer.instance.RelativeUrlTransformerMatcher;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import javax.annotation.Nullable;

public class DefaultStaticTransformersSupplier
implements StaticTransformersSupplier {
    private final Iterable<DescribedTransformer> describedTransformers;

    public DefaultStaticTransformersSupplier(WebResourceIntegration webResourceIntegration, WebResourceUrlProvider webResourceUrlProvider) {
        RelativeUrlTransformerFactory relativeUrlTransformerFactory = new RelativeUrlTransformerFactory(webResourceIntegration, webResourceUrlProvider);
        RelativeUrlTransformerMatcher relativeUrlTransformerMatcher = new RelativeUrlTransformerMatcher();
        this.describedTransformers = Lists.newArrayList((Object[])new DescribedTransformer[]{new DescribedTransformer(relativeUrlTransformerMatcher, relativeUrlTransformerFactory)});
    }

    @Override
    public Iterable<WebResourceTransformerFactory> get(final String type) {
        return DefaultStaticTransformersSupplier.toTransformerFactories(this.describedTransformers, new Predicate<DescribedTransformer>(){

            public boolean apply(@Nullable DescribedTransformer input) {
                return input.matcher.matches(type);
            }
        });
    }

    @Override
    public Iterable<WebResourceTransformerFactory> get(final ResourceLocation resourceLocation) {
        return DefaultStaticTransformersSupplier.toTransformerFactories(this.describedTransformers, new Predicate<DescribedTransformer>(){

            public boolean apply(@Nullable DescribedTransformer input) {
                return input.matcher.matches(resourceLocation);
            }
        });
    }

    private static Iterable<WebResourceTransformerFactory> toTransformerFactories(Iterable<DescribedTransformer> describedTransformers, Predicate<DescribedTransformer> predicate) {
        return Iterables.transform((Iterable)Iterables.filter(describedTransformers, predicate), (Function)new Function<DescribedTransformer, WebResourceTransformerFactory>(){

            public WebResourceTransformerFactory apply(@Nullable DescribedTransformer input) {
                return input.transformerFactory;
            }
        });
    }

    private static final class DescribedTransformer {
        private final WebResourceTransformerMatcher matcher;
        private final WebResourceTransformerFactory transformerFactory;

        private DescribedTransformer(WebResourceTransformerMatcher matcher, WebResourceTransformerFactory transformerFactory) {
            this.matcher = matcher;
            this.transformerFactory = transformerFactory;
        }
    }
}

