/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.condition;

import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.atlassian.plugin.webresource.condition.DecoratingCondition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ConditionState {
    private final Map<DecoratingCondition, Boolean> conditionValues;
    private final Set<WebResourceModuleDescriptor> webResourceModuleDescriptors;
    private final Set<String> resourceTypes;

    public ConditionState() {
        this.conditionValues = new HashMap<DecoratingCondition, Boolean>();
        this.webResourceModuleDescriptors = new HashSet<WebResourceModuleDescriptor>();
        this.resourceTypes = new HashSet<String>();
    }

    private ConditionState(ConditionState that) {
        this.conditionValues = new HashMap<DecoratingCondition, Boolean>(that.conditionValues);
        this.webResourceModuleDescriptors = new HashSet<WebResourceModuleDescriptor>(that.webResourceModuleDescriptors);
        this.resourceTypes = new HashSet<String>(that.resourceTypes);
    }

    public ConditionState copy() {
        return new ConditionState(this);
    }

    public Boolean getConditionResult(DecoratingCondition condition) {
        return this.conditionValues.get(condition);
    }

    public Set<DecoratingCondition> getConditions() {
        return this.conditionValues.keySet();
    }

    public Set<WebResourceModuleDescriptor> getWebResourceModuleDescriptors() {
        return this.webResourceModuleDescriptors;
    }

    public Set<String> getResourceTypes() {
        return this.resourceTypes;
    }

    public void addCondition(DecoratingCondition condition, boolean value) {
        this.conditionValues.put(condition, value);
    }

    public void addAll(ConditionState that) {
        this.conditionValues.putAll(that.conditionValues);
    }

    public void addWebResourceModuleDescriptor(WebResourceModuleDescriptor webResourceModuleDescriptor) {
        this.webResourceModuleDescriptors.add(webResourceModuleDescriptor);
    }

    public void addResourceType(String resourceType) {
        this.resourceTypes.add(resourceType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConditionState that = (ConditionState)o;
        if (!((Object)this.conditionValues).equals(that.conditionValues)) {
            return false;
        }
        if (!((Object)this.webResourceModuleDescriptors).equals(that.webResourceModuleDescriptors)) {
            return false;
        }
        return ((Object)this.resourceTypes).equals(that.resourceTypes);
    }

    public int hashCode() {
        int result = ((Object)this.conditionValues).hashCode();
        result = 31 * result + ((Object)this.webResourceModuleDescriptors).hashCode();
        result = 31 * result + ((Object)this.resourceTypes).hashCode();
        return result;
    }
}

