/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.webresource.QueryParams;
import com.atlassian.plugin.webresource.WebResourceTransformation;
import com.atlassian.plugin.webresource.condition.ConditionState;
import com.atlassian.plugin.webresource.condition.DecoratingCondition;
import com.atlassian.plugin.webresource.condition.UrlReadingConditionElementParser;
import com.atlassian.plugin.webresource.data.WebResourceDataProviderParser;
import com.atlassian.plugin.webresource.transformer.StaticTransformers;
import com.atlassian.plugin.webresource.transformer.TransformerParameters;
import com.atlassian.plugin.webresource.transformer.WebResourceTransformerModuleDescriptor;
import com.atlassian.plugin.webresource.url.DefaultUrlBuilder;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class WebResourceModuleDescriptor
extends AbstractModuleDescriptor<Void> {
    private List<String> dependencies = Collections.emptyList();
    private boolean disableMinification;
    private Set<String> contexts = Collections.emptySet();
    private final HostContainer hostContainer;
    private WebResourceDataProviderParser dataProviderParser;
    private Map<String, WebResourceDataProvider> dataProviders = Collections.emptyMap();
    private List<WebResourceTransformation> webResourceTransformations = Collections.emptyList();
    private UrlReadingConditionElementParser conditionElementParser;
    private Element element;
    private DecoratingCondition condition;

    @Deprecated
    public WebResourceModuleDescriptor(HostContainer hostContainer) {
        this(ModuleFactory.LEGACY_MODULE_FACTORY, hostContainer);
    }

    public WebResourceModuleDescriptor(ModuleFactory moduleFactory, HostContainer hostContainer) {
        super(moduleFactory);
        this.conditionElementParser = new UrlReadingConditionElementParser(hostContainer);
        this.hostContainer = hostContainer;
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        List dependencies = element.elements("dependency");
        if (!dependencies.isEmpty()) {
            ArrayList<String> deps = new ArrayList<String>(dependencies.size());
            for (Element dependency : dependencies) {
                deps.add(dependency.getTextTrim());
            }
            this.dependencies = ImmutableList.copyOf(deps);
        }
        HashSet<String> ctxs = new HashSet<String>(this.contexts.size());
        ctxs.add(this.getCompleteKey());
        List contexts = element.elements("context");
        if (!contexts.isEmpty()) {
            for (Element contextElement : contexts) {
                ctxs.add(contextElement.getTextTrim());
            }
        }
        this.contexts = ImmutableSet.copyOf(ctxs);
        List transformations = element.elements("transformation");
        if (!transformations.isEmpty()) {
            ArrayList<WebResourceTransformation> trans = new ArrayList<WebResourceTransformation>(transformations.size());
            for (Element e : transformations) {
                trans.add(new WebResourceTransformation(e));
            }
            this.webResourceTransformations = ImmutableList.copyOf(trans);
        }
        this.dataProviderParser = new WebResourceDataProviderParser(this.hostContainer, element.elements("data"));
        Attribute minifiedAttribute = element.attribute("disable-minification");
        this.disableMinification = minifiedAttribute == null ? false : Boolean.valueOf(minifiedAttribute.getValue());
        this.element = element;
    }

    public Void getModule() {
        throw new UnsupportedOperationException("There is no module for Web Resources");
    }

    public void enabled() {
        super.enabled();
        try {
            this.condition = (DecoratingCondition)this.conditionElementParser.makeConditions(this.plugin, this.element, 1);
        }
        catch (PluginParseException e) {
            throw new RuntimeException("Unable to enable web resource due to issue processing condition", e);
        }
        try {
            this.dataProviders = this.dataProviderParser.createDataProviders(this.plugin, ((Object)((Object)this)).getClass());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to enable web resource due to an isue processing data-provider", e);
        }
        catch (PluginParseException e) {
            throw new RuntimeException("Unable to enable web resource due to an isue processing data-provider", e);
        }
    }

    public void disabled() {
        super.disabled();
        this.condition = null;
        this.dataProviders = Collections.emptyMap();
    }

    public Set<String> getContexts() {
        return this.contexts;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    protected List<WebResourceTransformation> getTransformations() {
        return this.webResourceTransformations;
    }

    protected DecoratingCondition getCondition() {
        return this.condition;
    }

    public boolean isDisableMinification() {
        return this.disableMinification;
    }

    public void addToUrl(String type, StaticTransformers staticTransformers, PluginAccessor pluginAccessor, DefaultUrlBuilder urlBuilder, ConditionState conditionsRun) {
        if (null != this.getCondition()) {
            conditionsRun.addResourceType(type);
            conditionsRun.addWebResourceModuleDescriptor(this);
            this.getCondition().addToUrl(urlBuilder);
            if (!this.getCondition().canEncodeStateIntoUrl()) {
                urlBuilder.taint();
            }
        }
        for (WebResourceTransformation transformation : this.getTransformations()) {
            if (!transformation.matches(type)) continue;
            conditionsRun.addResourceType(type);
            conditionsRun.addWebResourceModuleDescriptor(this);
            transformation.addTransformParameters(pluginAccessor, this, urlBuilder);
            if (transformation.containsOnlyPureUrlReadingTransformers(pluginAccessor)) continue;
            urlBuilder.taint();
        }
        staticTransformers.addToUrl(type, TransformerParameters.of(this), urlBuilder);
    }

    public boolean canEncodeStateIntoUrl() {
        return this.getCondition() == null || this.getCondition().canEncodeStateIntoUrl();
    }

    public boolean shouldDisplay(QueryParams params) {
        return this.getCondition() == null || this.getCondition().shouldDisplay(params);
    }

    public boolean shouldDisplayImmediate() {
        return this.getCondition() == null || this.getCondition().shouldDisplayImmediate((Map<String, Object>)ImmutableMap.of());
    }

    public Map<String, WebResourceDataProvider> getDataProviders() {
        return this.dataProviders;
    }

    @Deprecated
    public Set<String> getDeprecatedConditionKeys() {
        final HashSet allConditions = Sets.newHashSet();
        UrlReadingConditionElementParser parser = new UrlReadingConditionElementParser(this.hostContainer){

            @Override
            protected DecoratingCondition makeConditionImplementation(Plugin plugin, Element element) throws PluginParseException {
                DecoratingCondition condition = super.makeConditionImplementation(plugin, element);
                if (!condition.canEncodeStateIntoUrl()) {
                    allConditions.add(element.attributeValue("class"));
                }
                return condition;
            }
        };
        parser.makeConditions(this.plugin, this.element, 1);
        return allConditions;
    }

    @Deprecated
    public Set<String> getDeprecatedTransformKeys(PluginAccessor pluginAccessor) {
        HashSet allTransforms = Sets.newHashSet();
        for (WebResourceTransformation transformation : this.getTransformations()) {
            for (WebResourceTransformerModuleDescriptor descriptor : transformation.getDeprecatedTransformers(pluginAccessor)) {
                allTransforms.add(descriptor.getCompleteKey());
            }
        }
        return allTransforms;
    }
}

