/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.cache.filecache.FileCache;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.util.EfficientStringUtils;
import com.atlassian.plugin.webresource.AbstractBatchResourceBuilder;
import com.atlassian.plugin.webresource.ContextBatchDownloadableResource;
import com.atlassian.plugin.webresource.ContextBatchOperations;
import com.atlassian.plugin.webresource.ContextBatchPluginResource;
import com.atlassian.plugin.webresource.DownloadableResourceFinder;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.ResourceDependencyResolver;
import com.atlassian.plugin.webresource.ResourceUtils;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.plugin.webresource.cache.CacheHandle;
import com.atlassian.plugin.webresource.cache.FileCacheKey;
import com.atlassian.plugin.webresource.condition.ConditionState;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.annotation.Nullable;

class ContextBatchDownloadableResourceBuilder
extends AbstractBatchResourceBuilder {
    private final ResourceDependencyResolver dependencyResolver;

    ContextBatchDownloadableResourceBuilder(ResourceDependencyResolver dependencyResolver, PluginAccessor pluginAccessor, WebResourceUrlProvider webResourceUrlProvider, DownloadableResourceFinder resourceFinder, FileCache<FileCacheKey> cache, ResourceBatchingConfiguration resourceBatchingConfiguration) {
        super(pluginAccessor, webResourceUrlProvider, resourceFinder, cache, resourceBatchingConfiguration);
        this.dependencyResolver = dependencyResolver;
    }

    @Override
    public boolean matches(String path) {
        String type = ResourceUtils.getType(path);
        boolean hasPrefix = path.contains(ContextBatchPluginResource.REMOVE_SB_URL_PREFIX + type) || path.contains(ContextBatchPluginResource.INCLUDE_SB_URL_PREFIX + type);
        return hasPrefix && EfficientStringUtils.endsWith((String)path, (String[])new String[]{"batch", ".", type});
    }

    @Override
    public ContextBatchDownloadableResource parse(String path, final Map<String, String> params) {
        final String type = ResourceUtils.getType(path);
        boolean excludeSuperBatchedResources = path.contains(ContextBatchPluginResource.REMOVE_SB_URL_PREFIX + type);
        String key = this.getKey(path);
        LinkedHashSet<String> includedContexts = new LinkedHashSet<String>();
        HashSet<String> excludedContexts = new HashSet<String>();
        ConditionState conditionsRun = new ConditionState();
        ContextBatchOperations.parseContexts(key, includedContexts, excludedContexts);
        LinkedHashSet moduleDescriptors = new LinkedHashSet();
        for (String context : includedContexts) {
            Iterables.addAll(moduleDescriptors, this.dependencyResolver.getDependenciesInContext(context, excludeSuperBatchedResources, conditionsRun));
        }
        for (String context : excludedContexts) {
            ArrayList dependencies = new ArrayList();
            Iterables.addAll(dependencies, this.dependencyResolver.getDependenciesInContext(context, excludeSuperBatchedResources, conditionsRun));
            moduleDescriptors.removeAll(dependencies);
        }
        Iterable resources = Iterables.concat((Iterable)Iterables.transform(moduleDescriptors, (Function)new Function<WebResourceModuleDescriptor, Iterable<DownloadableResource>>(){

            public Iterable<DownloadableResource> apply(@Nullable WebResourceModuleDescriptor moduleDescriptor) {
                return ContextBatchDownloadableResourceBuilder.this.resolve((ModuleDescriptor<?>)moduleDescriptor, type, (Map<String, String>)params);
            }
        }));
        CacheHandle cacher = CacheHandle.Builder.forRequest(this.cache, "context", path, params);
        return new ContextBatchDownloadableResource(type, params, resources, cacher, this.resourceBatchingConfiguration);
    }

    private String getKey(String path) {
        int secondSlashIndex = path.lastIndexOf("/");
        int firstSlashIndex = path.lastIndexOf("/", secondSlashIndex - 1);
        return path.substring(firstSlashIndex + 1, secondSlashIndex);
    }
}

