/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.url;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.atlassian.plugin.webresource.url.DefaultUrlBuilder;
import com.atlassian.plugin.webresource.url.UrlParameters;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Map;

public class DefaultUrlBuilderMap {
    private final Iterable<WebResourceModuleDescriptor> wrmds;
    private final PluginAccessor pluginAccessor;
    private final Map<String, UrlParameters> urlBuildersByType;

    public DefaultUrlBuilderMap(WebResourceModuleDescriptor wrmd, PluginAccessor pluginAccessor) {
        this.wrmds = ImmutableList.of((Object)((Object)wrmd));
        this.pluginAccessor = pluginAccessor;
        this.urlBuildersByType = Maps.newHashMap();
    }

    public DefaultUrlBuilderMap(Iterable<WebResourceModuleDescriptor> wrmds, PluginAccessor pluginAccessor) {
        this.wrmds = Lists.newArrayList(wrmds);
        this.pluginAccessor = pluginAccessor;
        this.urlBuildersByType = Maps.newHashMap();
    }

    public UrlParameters getOrCreateForType(String type) {
        UrlParameters urlParams = this.urlBuildersByType.get(type);
        if (null == urlParams) {
            DefaultUrlBuilder urlBuilder = new DefaultUrlBuilder();
            for (WebResourceModuleDescriptor wrmd : this.wrmds) {
                wrmd.addToUrl(type, this.pluginAccessor, urlBuilder);
            }
            urlParams = urlBuilder.build();
            this.urlBuildersByType.put(type, urlParams);
        }
        return urlParams;
    }
}

