/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.QueryParams;
import com.atlassian.plugin.webresource.transformer.TransformableResource;
import com.atlassian.plugin.webresource.transformer.UrlReadingWebResourceTransformerModuleDescriptor;
import com.atlassian.plugin.webresource.transformer.WebResourceTransformerModuleDescriptor;
import com.atlassian.plugin.webresource.url.UrlBuilder;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebResourceTransformation {
    private final String extension;
    private final Map<String, Element> transformerElements;
    private Logger log = LoggerFactory.getLogger(WebResourceTransformation.class);

    public WebResourceTransformation(Element element) {
        Validate.notNull((Object)element.attribute("extension"));
        this.extension = "." + element.attributeValue("extension");
        LinkedHashMap<String, Element> transformers = new LinkedHashMap<String, Element>();
        for (Element transformElement : element.elements("transformer")) {
            transformers.put(transformElement.attributeValue("key"), transformElement);
        }
        this.transformerElements = Collections.unmodifiableMap(transformers);
    }

    public boolean matches(ResourceLocation location) {
        String loc = location.getLocation();
        if (loc == null || "".equals(loc.trim())) {
            loc = location.getName();
        }
        return loc.endsWith(this.extension);
    }

    public void addTransformParameters(PluginAccessor pluginAccessor, UrlBuilder urlBuilder) {
        for (Map.Entry<String, Element> entry : this.transformerElements.entrySet()) {
            for (UrlReadingWebResourceTransformerModuleDescriptor descriptor : this.urlReadingTransformersByKey(pluginAccessor, entry.getKey())) {
                descriptor.getModule().makeUrlBuilder(entry.getValue()).addToUrl(urlBuilder);
            }
        }
    }

    public DownloadableResource transformDownloadableResource(PluginAccessor pluginAccessor, DownloadableResource resource, ResourceLocation resourceLocation, String filePath, QueryParams params) {
        DownloadableResource lastResource = resource;
        for (Map.Entry<String, Element> entry : this.transformerElements.entrySet()) {
            boolean found = false;
            for (UrlReadingWebResourceTransformerModuleDescriptor urlReadingWebResourceTransformerModuleDescriptor : this.urlReadingTransformersByKey(pluginAccessor, entry.getKey())) {
                found = true;
                TransformableResource transformableResource = new TransformableResource(resourceLocation, filePath, lastResource);
                lastResource = urlReadingWebResourceTransformerModuleDescriptor.getModule().makeResourceTransformer(entry.getValue()).transform(transformableResource, params);
            }
            if (!found) {
                for (WebResourceTransformerModuleDescriptor webResourceTransformerModuleDescriptor : this.transformersByKey(pluginAccessor, entry.getKey())) {
                    found = true;
                    lastResource = webResourceTransformerModuleDescriptor.getModule().transform(entry.getValue(), resourceLocation, filePath, lastResource);
                }
            }
            if (found) continue;
            this.log.warn("Web resource transformer {} not found for resource {}, skipping", (Object)entry.getKey(), (Object)resourceLocation.getName());
        }
        return lastResource;
    }

    private Iterable<UrlReadingWebResourceTransformerModuleDescriptor> urlReadingTransformersByKey(PluginAccessor pluginAccessor, String key) {
        return this.transformersByKey(pluginAccessor, UrlReadingWebResourceTransformerModuleDescriptor.class, key);
    }

    private Iterable<WebResourceTransformerModuleDescriptor> transformersByKey(PluginAccessor pluginAccessor, String key) {
        return this.transformersByKey(pluginAccessor, WebResourceTransformerModuleDescriptor.class, key);
    }

    private <D extends ModuleDescriptor<?>> Iterable<D> transformersByKey(PluginAccessor pluginAccessor, Class<D> clazz, final String key) {
        return Iterables.filter((Iterable)pluginAccessor.getEnabledModuleDescriptorsByClass(clazz), (Predicate)new Predicate<D>(){

            public boolean apply(@Nullable D descriptor) {
                return descriptor.getKey().equals(key);
            }
        });
    }
}

