/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.webresource.BatchedWebResourceDescriptor;
import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.plugin.webresource.url.NamedHash;
import com.atlassian.plugin.webresource.util.HashBuilder;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPluginResource
implements PluginResource {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPluginResource.class);
    protected List<NamedHash> hashes;
    protected final Map<String, String> params;
    protected final Map<String, String> batchableParams;
    protected final Set<BatchedWebResourceDescriptor> batchedWebResourceDescriptors;

    protected AbstractPluginResource(List<NamedHash> hashes, Map<String, String> params, Map<String, String> batchableParams, Set<BatchedWebResourceDescriptor> batchedWebResourceDescriptors) {
        this.hashes = ImmutableList.copyOf(hashes);
        this.params = ImmutableMap.copyOf(params);
        this.batchableParams = ImmutableMap.copyOf(batchableParams);
        this.batchedWebResourceDescriptors = batchedWebResourceDescriptors;
    }

    @Override
    public List<NamedHash> getHashes() {
        return this.hashes;
    }

    @Override
    public Map<String, String> getParams() {
        return this.params;
    }

    @Override
    public Map<String, String> getBatchableParams() {
        return this.batchableParams;
    }

    @Override
    public Set<BatchedWebResourceDescriptor> getBatchedWebResourceDescriptors() {
        return this.batchedWebResourceDescriptors;
    }

    @Override
    public String getStaticUrl(WebResourceIntegration webResourceIntegration, WebResourceUrlProvider webResourceUrlProvider, UrlMode urlMode) {
        String prefix;
        if (this.isCacheSupported()) {
            List hashes = Lists.transform(this.getHashes(), (Function)new Function<NamedHash, String>(){

                public String apply(@Nullable NamedHash namedHash) {
                    return namedHash.getHash();
                }
            });
            String contributedHash = HashBuilder.buildHash(hashes);
            prefix = webResourceUrlProvider.getStaticResourcePrefix(contributedHash, this.getVersion(webResourceIntegration), urlMode);
        } else {
            prefix = webResourceUrlProvider.getBaseUrl(urlMode);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Static hashes for url: {}", (Object)this.getUrl());
            for (NamedHash namedHash : this.getHashes()) {
                logger.debug("{}: {}", (Object)namedHash.getName(), (Object)namedHash.getHash());
            }
        }
        return prefix + this.getUrl();
    }
}

