package com.atlassian.plugin.webresource;

import java.io.IOException;
import java.io.OutputStream;

/**
 * Implemented by classes that want to annotate the write of a plugin resource.
 */
public interface ResourceContentAnnotator
{
    /**
     * Called before the resource content is written.
     * 
     * @param stream
     * @throws IOException if there is a problem writing the annotation. 
     */
    void before(OutputStream stream) throws IOException;
    
    /**
     * Called after the resource content is written.
     * 
     * @param stream
     * @throws IOException if there is a problem writing the annotation.
     */
    void after(OutputStream stream) throws IOException;
}
