/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.webresource.BatchResourceComparator;
import com.atlassian.plugin.webresource.BatchedWebResourceDescriptor;
import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.ResourceDependencyResolver;
import com.atlassian.plugin.webresource.SuperBatchOperations;
import com.atlassian.plugin.webresource.SuperBatchPluginResource;
import com.atlassian.plugin.webresource.WebResourceFilter;
import com.atlassian.plugin.webresource.WebResourceFormatter;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SuperBatchBuilder {
    private final ResourceDependencyResolver dependencyResolver;
    private final PluginResourceLocator pluginResourceLocator;
    private final WebResourceIntegration webResourceIntegration;

    public SuperBatchBuilder(ResourceDependencyResolver dependencyResolver, PluginResourceLocator pluginResourceLocator, WebResourceIntegration webResourceIntegration) {
        this.dependencyResolver = dependencyResolver;
        this.pluginResourceLocator = pluginResourceLocator;
        this.webResourceIntegration = webResourceIntegration;
    }

    public Iterable<PluginResource> build(WebResourceFilter filter) {
        Iterable<WebResourceModuleDescriptor> superBatchModuleKeys = this.dependencyResolver.getSuperBatchDependencies();
        ArrayList<PluginResource> resources = new ArrayList<PluginResource>();
        for (WebResourceFormatter formatter : WebResourceFormatter.webResourceFormatters) {
            HashMap<Map<String, String>, SuperBatchPluginResource> resourceByParams = new HashMap<Map<String, String>, SuperBatchPluginResource>();
            for (WebResourceModuleDescriptor moduleDescriptor : superBatchModuleKeys) {
                for (PluginResource pluginResource : this.pluginResourceLocator.getPluginResources(moduleDescriptor.getCompleteKey())) {
                    if (!formatter.matches(pluginResource.getResourceName()) || !filter.matches(pluginResource.getResourceName())) continue;
                    Map<String, String> batchParamsMap = this.getParamMap(pluginResource);
                    if (!resourceByParams.containsKey(batchParamsMap)) {
                        resourceByParams.put(batchParamsMap, SuperBatchPluginResource.createBatchFor(pluginResource));
                    } else {
                        resourceByParams.put(batchParamsMap, SuperBatchOperations.mergeSameBatch((SuperBatchPluginResource)resourceByParams.get(batchParamsMap), pluginResource));
                    }
                    SuperBatchPluginResource superBatchPluginResource = (SuperBatchPluginResource)resourceByParams.get(batchParamsMap);
                    BatchedWebResourceDescriptor descriptor = new BatchedWebResourceDescriptor(pluginResource.getVersion(this.webResourceIntegration), pluginResource.getModuleCompleteKey());
                    superBatchPluginResource.addBatchedWebResourceDescriptor(descriptor);
                }
            }
            ArrayList resourcesForFormatter = Lists.newArrayList(resourceByParams.values());
            Collections.sort(resourcesForFormatter, BatchResourceComparator.INSTANCE);
            resources.addAll(resourcesForFormatter);
        }
        return resources;
    }

    private Map<String, String> getParamMap(PluginResource pluginResource) {
        HashMap<String, String> batchParamsMap = new HashMap<String, String>(PluginResourceLocator.BATCH_PARAMS.length);
        for (String s : PluginResourceLocator.BATCH_PARAMS) {
            batchParamsMap.put(s, pluginResource.getParams().get(s));
        }
        return batchParamsMap;
    }
}

