/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.servlet;

import com.atlassian.plugin.servlet.ContentTypeResolver;
import com.atlassian.plugin.servlet.DownloadException;
import com.atlassian.plugin.servlet.DownloadStrategy;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.servlet.util.LastModifiedHandler;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.ResourceUtils;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginResourceDownload
implements DownloadStrategy {
    private static final Logger log = LoggerFactory.getLogger(PluginResourceDownload.class);
    private String characterEncoding = "UTF-8";
    private PluginResourceLocator pluginResourceLocator;
    private ContentTypeResolver contentTypeResolver;

    public PluginResourceDownload() {
    }

    public PluginResourceDownload(PluginResourceLocator pluginResourceLocator, ContentTypeResolver contentTypeResolver, String characterEncoding) {
        this.characterEncoding = characterEncoding;
        this.pluginResourceLocator = pluginResourceLocator;
        this.contentTypeResolver = contentTypeResolver;
    }

    public boolean matches(String urlPath) {
        return this.pluginResourceLocator.matches(urlPath);
    }

    public void serveFile(HttpServletRequest request, HttpServletResponse response) throws DownloadException {
        try {
            LastModifiedHandler lastModifiedHandler;
            Map<String, String> params = ResourceUtils.getQueryParameters(request);
            boolean cacheableResource = ResourceUtils.canRequestedResourcesContentBeAssumedConstant(params);
            if (cacheableResource && (lastModifiedHandler = new LastModifiedHandler(new Date(request.getDateHeader("If-Modified-Since")))).checkRequest(request, response)) {
                return;
            }
            String requestUri = URLDecoder.decode(request.getRequestURI(), this.characterEncoding);
            DownloadableResource downloadableResource = this.pluginResourceLocator.getDownloadableResource(requestUri, params);
            if (downloadableResource == null) {
                log.info("Could not locate resource: {}", (Object)request.getRequestURI());
                response.sendError(404);
                return;
            }
            if (cacheableResource && !downloadableResource.isResourceModified(request, response)) {
                return;
            }
            String contentType = this.getContentType(requestUri, downloadableResource);
            if (contentType != null) {
                response.setContentType(contentType);
            }
            downloadableResource.serveResource(request, response);
        }
        catch (IOException e) {
            throw new DownloadException((Exception)e);
        }
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public void setContentTypeResolver(ContentTypeResolver contentTypeResolver) {
        this.contentTypeResolver = contentTypeResolver;
    }

    public void setPluginResourceLocator(PluginResourceLocator pluginResourceLocator) {
        this.pluginResourceLocator = pluginResourceLocator;
    }

    private String getContentType(String requestUri, DownloadableResource downloadableResource) {
        String contentType = downloadableResource.getContentType();
        if (contentType == null) {
            return this.contentTypeResolver.getContentType(requestUri);
        }
        return contentType;
    }
}

