/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.condition;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.loaders.LoaderUtils;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.baseconditions.AbstractConditionElementParser;
import com.atlassian.plugin.web.baseconditions.CompositeCondition;
import com.atlassian.plugin.web.conditions.ConditionLoadingException;
import com.atlassian.plugin.webresource.condition.DecoratingLegacyCondition;
import com.atlassian.plugin.webresource.condition.UrlReadingAndCompositeCondition;
import com.atlassian.plugin.webresource.condition.UrlReadingCondition;
import com.atlassian.plugin.webresource.condition.UrlReadingInvertedCondition;
import com.atlassian.plugin.webresource.condition.UrlReadingOrCompositeCondition;
import com.atlassian.plugin.webresource.util.PluginClassLoader;
import org.dom4j.Element;

public class UrlReadingConditionElementParser
extends AbstractConditionElementParser<UrlReadingCondition> {
    private final HostContainer hostContainer;

    public UrlReadingConditionElementParser(HostContainer hostContainer) {
        this.hostContainer = hostContainer;
    }

    protected UrlReadingCondition makeConditionImplementation(Plugin plugin, Element element) throws PluginParseException {
        try {
            String conditionClassName;
            String overrideConditionClassName = element.attributeValue("class2");
            String string = conditionClassName = null != overrideConditionClassName ? overrideConditionClassName : element.attributeValue("class");
            if (conditionClassName == null) {
                throw new PluginParseException("Condition element must specify a class attribute");
            }
            UrlReadingCondition condition = this.create(plugin, conditionClassName);
            condition.init(LoaderUtils.getParams((Element)element));
            return condition;
        }
        catch (ClassCastException e) {
            throw new PluginParseException("Configured condition class does not implement the Condition interface", (Throwable)e);
        }
        catch (ConditionLoadingException cle) {
            throw new PluginParseException("Unable to load the module's display conditions: " + cle.getMessage(), (Throwable)cle);
        }
    }

    private UrlReadingCondition create(Plugin plugin, String className) throws ConditionLoadingException {
        Object o = this.createObject(plugin, className);
        if (o instanceof UrlReadingCondition) {
            return (UrlReadingCondition)o;
        }
        return new DecoratingLegacyCondition((Condition)o);
    }

    private <T> T createObject(Plugin plugin, String className) throws ConditionLoadingException {
        try {
            return PluginClassLoader.create(plugin, ((Object)((Object)this)).getClass(), this.hostContainer, className);
        }
        catch (ClassNotFoundException e) {
            throw new ConditionLoadingException("Cannot load condition class: " + className, (Throwable)e);
        }
    }

    protected UrlReadingCondition invert(UrlReadingCondition condition) {
        return new UrlReadingInvertedCondition(condition);
    }

    protected CompositeCondition<UrlReadingCondition> createAndCompositeCondition() {
        return new UrlReadingAndCompositeCondition();
    }

    protected CompositeCondition<UrlReadingCondition> createOrCompositeCondition() {
        return new UrlReadingOrCompositeCondition();
    }
}

