/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.webresource.ContextBatchBuilder;
import com.atlassian.plugin.webresource.CssWebResource;
import com.atlassian.plugin.webresource.DefaultResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.DefaultResourceDependencyResolver;
import com.atlassian.plugin.webresource.DefaultWebResourceFilter;
import com.atlassian.plugin.webresource.JavascriptWebResource;
import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.ResourceDependencyResolver;
import com.atlassian.plugin.webresource.SuperBatchPluginResource;
import com.atlassian.plugin.webresource.TransformDescriptorToKey;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceFilter;
import com.atlassian.plugin.webresource.WebResourceFormatter;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.atlassian.plugin.webresource.WebResourceRequestContext;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebResourceManagerImpl
implements WebResourceManager {
    private static final Logger log = LoggerFactory.getLogger(WebResourceManagerImpl.class);
    static final String STATIC_RESOURCE_PREFIX = "s";
    static final String STATIC_RESOURCE_SUFFIX = "_";
    static final String REQUEST_CACHE_RESOURCE_KEY = "plugin.webresource.names";
    static final String REQUEST_CACHE_CONTEXT_KEY = "plugin.webresource.contexts";
    protected final WebResourceIntegration webResourceIntegration;
    protected final PluginResourceLocator pluginResourceLocator;
    private final WebResourceUrlProvider webResourceUrlProvider;
    protected final ResourceBatchingConfiguration batchingConfiguration;
    protected final ResourceDependencyResolver dependencyResolver;
    protected static final List<WebResourceFormatter> webResourceFormatters = Arrays.asList(CssWebResource.FORMATTER, JavascriptWebResource.FORMATTER);
    private static final boolean IGNORE_SUPERBATCHING = false;
    @Deprecated
    private static final String REQUEST_CACHE_MODE_KEY = "plugin.webresource.mode";

    public WebResourceManagerImpl(PluginResourceLocator pluginResourceLocator, WebResourceIntegration webResourceIntegration, WebResourceUrlProvider webResourceUrlProvider) {
        this(pluginResourceLocator, webResourceIntegration, webResourceUrlProvider, new DefaultResourceBatchingConfiguration());
    }

    public WebResourceManagerImpl(PluginResourceLocator pluginResourceLocator, WebResourceIntegration webResourceIntegration, WebResourceUrlProvider webResourceUrlProvider, ResourceBatchingConfiguration batchingConfiguration) {
        this(pluginResourceLocator, webResourceIntegration, webResourceUrlProvider, batchingConfiguration, new DefaultResourceDependencyResolver(webResourceIntegration, batchingConfiguration));
    }

    public WebResourceManagerImpl(PluginResourceLocator pluginResourceLocator, WebResourceIntegration webResourceIntegration, WebResourceUrlProvider webResourceUrlProvider, ResourceBatchingConfiguration batchingConfiguration, ResourceDependencyResolver dependencyResolver) {
        this.pluginResourceLocator = pluginResourceLocator;
        this.webResourceIntegration = webResourceIntegration;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.batchingConfiguration = batchingConfiguration;
        this.dependencyResolver = dependencyResolver;
    }

    @Override
    public void requireResource(String moduleCompleteKey) {
        log.debug("Requiring resource: " + moduleCompleteKey);
        Iterable<String> dependencies = this.transformModuleDescriptorsToModuleKeys(this.dependencyResolver.getDependencies(moduleCompleteKey, this.batchingConfiguration.isSuperBatchingEnabled()));
        Iterables.addAll(this.getIncludedResourceNames(), dependencies);
    }

    @Override
    public void requireResourcesForContext(String context) {
        this.getIncludedContexts().add(context);
    }

    private Set<String> getIncludedContexts() {
        return this.getOrCreateFromRequestCache(REQUEST_CACHE_CONTEXT_KEY);
    }

    private Set<String> getIncludedResourceNames() {
        return this.getOrCreateFromRequestCache(REQUEST_CACHE_RESOURCE_KEY);
    }

    private Set<String> getOrCreateFromRequestCache(String key) {
        Map<String, Object> cache = this.webResourceIntegration.getRequestCache();
        LinkedHashSet set = (LinkedHashSet)cache.get(key);
        if (set == null) {
            set = new LinkedHashSet();
            cache.put(key, set);
        }
        return set;
    }

    private void clear() {
        log.debug("Clearing included resources and contexts");
        this.getIncludedResourceNames().clear();
        this.getIncludedContexts().clear();
    }

    @Override
    public void includeResources(Writer writer) {
        this.includeResources(writer, UrlMode.AUTO);
    }

    @Override
    public void includeResources(Iterable<String> moduleCompleteKeys, Writer writer, UrlMode urlMode) {
        Iterable resources = Lists.newArrayList();
        for (String moduleCompleteKey : moduleCompleteKeys) {
            Iterable<String> dependencies = this.transformModuleDescriptorsToModuleKeys(this.dependencyResolver.getDependencies(moduleCompleteKey, false));
            resources = Iterables.concat((Iterable)resources, dependencies);
        }
        resources = ImmutableSet.copyOf((Iterable)resources);
        this.writeResourceTags(this.getModuleResources(resources, Collections.<String>emptyList(), DefaultWebResourceFilter.INSTANCE), writer, urlMode);
    }

    @Override
    public void includeResources(Writer writer, UrlMode urlMode) {
        this.includeResources(writer, urlMode, DefaultWebResourceFilter.INSTANCE);
    }

    @Override
    public void includeResources(Writer writer, UrlMode urlMode, WebResourceFilter webResourceFilter) {
        this.writeIncludedResources(writer, urlMode, webResourceFilter);
        this.clear();
    }

    @Override
    public String getRequiredResources() {
        return this.getRequiredResources(UrlMode.AUTO);
    }

    @Override
    public String getRequiredResources(UrlMode urlMode) {
        return this.getRequiredResources(urlMode, DefaultWebResourceFilter.INSTANCE);
    }

    @Override
    public String getRequiredResources(UrlMode urlMode, WebResourceFilter webResourceFilter) {
        StringWriter writer = new StringWriter();
        this.writeIncludedResources(writer, urlMode, webResourceFilter);
        return writer.toString();
    }

    private void writeIncludedResources(Writer writer, UrlMode urlMode, WebResourceFilter filter) {
        Iterable<PluginResource> resourcesToInclude = this.getSuperBatchResources(filter);
        ContextBatchBuilder builder = new ContextBatchBuilder(this.pluginResourceLocator, this.dependencyResolver, this.batchingConfiguration);
        resourcesToInclude = Iterables.concat(resourcesToInclude, builder.build(this.getIncludedContexts(), filter));
        for (String skippedResource : builder.getSkippedResources()) {
            this.requireResource(skippedResource);
        }
        resourcesToInclude = Iterables.concat(resourcesToInclude, this.getModuleResources(this.getIncludedResourceNames(), builder.getAllIncludedResources(), filter));
        this.writeResourceTags(resourcesToInclude, writer, urlMode);
    }

    List<PluginResource> getSuperBatchResources(WebResourceFilter filter) {
        if (!this.batchingConfiguration.isSuperBatchingEnabled()) {
            return Collections.emptyList();
        }
        Iterable<WebResourceModuleDescriptor> superBatchModuleKeys = this.dependencyResolver.getSuperBatchDependencies();
        ArrayList<PluginResource> resources = new ArrayList<PluginResource>();
        for (WebResourceFormatter formatter : webResourceFormatters) {
            HashSet alreadyIncluded = new HashSet();
            for (WebResourceModuleDescriptor moduleDescriptor : superBatchModuleKeys) {
                for (PluginResource pluginResource : this.pluginResourceLocator.getPluginResources(moduleDescriptor.getCompleteKey())) {
                    if (!formatter.matches(pluginResource.getResourceName()) || !filter.matches(pluginResource.getResourceName())) continue;
                    HashMap<String, String> batchParamsMap = new HashMap<String, String>(PluginResourceLocator.BATCH_PARAMS.length);
                    for (String s : PluginResourceLocator.BATCH_PARAMS) {
                        batchParamsMap.put(s, pluginResource.getParams().get(s));
                    }
                    if (alreadyIncluded.contains(batchParamsMap)) continue;
                    resources.add(SuperBatchPluginResource.createBatchFor(pluginResource));
                    alreadyIncluded.add(batchParamsMap);
                }
            }
        }
        return resources;
    }

    private Iterable<PluginResource> getModuleResources(Iterable<String> webResourcePluginModuleKeys, Iterable<String> batchedModules, WebResourceFilter filter) {
        ArrayList<PluginResource> includedResources = new ArrayList<PluginResource>();
        for (String moduleKey : webResourcePluginModuleKeys) {
            if (Iterables.contains(batchedModules, (Object)moduleKey)) continue;
            List<PluginResource> moduleResources = this.pluginResourceLocator.getPluginResources(moduleKey);
            for (PluginResource moduleResource : moduleResources) {
                if (filter.matches(moduleResource.getResourceName())) {
                    includedResources.add(moduleResource);
                    continue;
                }
                log.debug("Resource [" + moduleResource.getResourceName() + "] excluded by filter");
            }
        }
        return includedResources;
    }

    private void writeResourceTags(Iterable<PluginResource> resourcesToInclude, Writer writer, UrlMode urlMode) {
        for (WebResourceFormatter formatter : webResourceFormatters) {
            Iterator<PluginResource> iter = resourcesToInclude.iterator();
            while (iter.hasNext()) {
                PluginResource resource = iter.next();
                if (!formatter.matches(resource.getResourceName())) continue;
                this.writeResourceTag(urlMode, resource, formatter, writer);
                iter.remove();
            }
        }
        for (PluginResource resource : resourcesToInclude) {
            this.writeContentAndSwallowErrors("<!-- Error loading resource \"" + resource.getModuleCompleteKey() + "\".  No resource formatter matches \"" + resource.getResourceName() + "\" -->\n", writer);
        }
    }

    private void writeResourceTag(UrlMode urlMode, PluginResource resource, WebResourceFormatter formatter, Writer writer) {
        String url = resource.getUrl();
        url = resource.isCacheSupported() ? this.webResourceUrlProvider.getStaticResourcePrefix(resource.getVersion(this.webResourceIntegration), urlMode) + url : this.webResourceUrlProvider.getBaseUrl(urlMode) + url;
        this.writeContentAndSwallowErrors(formatter.formatResource(url, resource.getParams()), writer);
    }

    @Override
    public void requireResource(String moduleCompleteKey, Writer writer) {
        this.requireResource(moduleCompleteKey, writer, UrlMode.AUTO);
    }

    @Override
    public void requireResource(String moduleCompleteKey, Writer writer, UrlMode urlMode) {
        Iterable<String> allDependentModuleKeys = this.transformModuleDescriptorsToModuleKeys(this.dependencyResolver.getDependencies(moduleCompleteKey, false));
        List<String> empty = Collections.emptyList();
        Iterable<PluginResource> resourcesToInclude = this.getModuleResources(allDependentModuleKeys, empty, DefaultWebResourceFilter.INSTANCE);
        this.writeResourceTags(resourcesToInclude, writer, urlMode);
    }

    @Override
    public String getResourceTags(String moduleCompleteKey) {
        return this.getResourceTags(moduleCompleteKey, UrlMode.AUTO);
    }

    @Override
    public String getResourceTags(String moduleCompleteKey, UrlMode urlMode) {
        StringWriter writer = new StringWriter();
        this.requireResource(moduleCompleteKey, writer, urlMode);
        return writer.toString();
    }

    private void writeContentAndSwallowErrors(String content, Writer writer) {
        try {
            writer.write(content);
        }
        catch (IOException e) {
            log.debug("Ignoring", (Throwable)e);
        }
    }

    @Override
    public String getStaticResourcePrefix() {
        return this.getStaticResourcePrefix(UrlMode.AUTO);
    }

    @Override
    public String getStaticResourcePrefix(UrlMode urlMode) {
        return this.webResourceUrlProvider.getStaticResourcePrefix(urlMode);
    }

    @Override
    public String getStaticResourcePrefix(String resourceCounter) {
        return this.getStaticResourcePrefix(resourceCounter, UrlMode.AUTO);
    }

    @Override
    public String getStaticResourcePrefix(String resourceCounter, UrlMode urlMode) {
        return this.webResourceUrlProvider.getStaticResourcePrefix(resourceCounter, urlMode);
    }

    @Override
    public String getStaticPluginResource(String moduleCompleteKey, String resourceName) {
        return this.getStaticPluginResource(moduleCompleteKey, resourceName, UrlMode.AUTO);
    }

    @Override
    public String getStaticPluginResource(String moduleCompleteKey, String resourceName, UrlMode urlMode) {
        return this.webResourceUrlProvider.getStaticPluginResourceUrl(moduleCompleteKey, resourceName, urlMode);
    }

    public String getStaticPluginResource(ModuleDescriptor moduleDescriptor, String resourceName) {
        return this.getStaticPluginResource(moduleDescriptor, resourceName, UrlMode.AUTO);
    }

    public String getStaticPluginResource(ModuleDescriptor moduleDescriptor, String resourceName, UrlMode urlMode) {
        return this.webResourceUrlProvider.getStaticPluginResourceUrl(moduleDescriptor, resourceName, urlMode);
    }

    @Override
    public Object push() {
        Set<String> contexts = this.getOrCreateFromRequestCache(REQUEST_CACHE_CONTEXT_KEY);
        Set<String> resources = this.getOrCreateFromRequestCache(REQUEST_CACHE_RESOURCE_KEY);
        WebResourceRequestContext context = new WebResourceRequestContext();
        context.setContexts(contexts);
        context.setResources(resources);
        Map<String, Object> cache = this.webResourceIntegration.getRequestCache();
        cache.remove(REQUEST_CACHE_CONTEXT_KEY);
        cache.remove(REQUEST_CACHE_RESOURCE_KEY);
        return context;
    }

    @Override
    public void pop(Object oldState) {
        WebResourceRequestContext oldContext;
        try {
            oldContext = (WebResourceRequestContext)oldState;
        }
        catch (ClassCastException e) {
            return;
        }
        Map<String, Object> cache = this.webResourceIntegration.getRequestCache();
        cache.put(REQUEST_CACHE_CONTEXT_KEY, oldContext.getContexts());
        cache.put(REQUEST_CACHE_RESOURCE_KEY, oldContext.getResources());
    }

    private Iterable<String> transformModuleDescriptorsToModuleKeys(Iterable<WebResourceModuleDescriptor> descriptors) {
        return Iterables.transform(descriptors, (Function)new TransformDescriptorToKey());
    }

    @Deprecated
    public String getStaticPluginResourcePrefix(ModuleDescriptor moduleDescriptor, String resourceName) {
        return this.getStaticPluginResource(moduleDescriptor, resourceName);
    }

    @Override
    @Deprecated
    public void setIncludeMode(WebResourceManager.IncludeMode includeMode) {
        this.webResourceIntegration.getRequestCache().put(REQUEST_CACHE_MODE_KEY, includeMode);
    }
}

