/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.servlet.DownloadException;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.BatchPluginResource;
import com.atlassian.plugin.webresource.BatchResource;
import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ContextBatchPluginResource
implements DownloadableResource,
BatchResource,
PluginResource {
    static final String CONTEXT_SEPARATOR = ",";
    static final String URL_PREFIX = "/download/contextbatch/";
    static final String DEFAULT_RESOURCE_NAME_PREFIX = "batch";
    private final BatchPluginResource delegate;
    private final String resourceName;
    private final String key;
    private final Iterable<String> contexts;
    private final String hash;

    ContextBatchPluginResource(String key, Iterable<String> contexts, String hash, String type, Map<String, String> params) {
        this(key, contexts, hash, type, params, Collections.emptyList());
    }

    ContextBatchPluginResource(String key, Iterable<String> contexts, String type, Map<String, String> params, Iterable<DownloadableResource> resources) {
        this(key, contexts, null, type, params, resources);
    }

    private ContextBatchPluginResource(String key, Iterable<String> contexts, String hash, String type, Map<String, String> params, Iterable<DownloadableResource> resources) {
        this.resourceName = "batch." + type;
        this.delegate = new BatchPluginResource(null, type, params, resources);
        this.key = key;
        this.contexts = contexts;
        this.hash = hash;
    }

    Iterable<String> getContexts() {
        return this.contexts;
    }

    @Override
    public boolean isResourceModified(HttpServletRequest request, HttpServletResponse response) {
        return this.delegate.isResourceModified(request, response);
    }

    @Override
    public void serveResource(HttpServletRequest request, HttpServletResponse response) throws DownloadException {
        this.delegate.serveResource(request, response);
    }

    @Override
    public void streamResource(OutputStream out) throws DownloadException {
        this.delegate.streamResource(out);
    }

    @Override
    public String getContentType() {
        return this.delegate.getContentType();
    }

    boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public String getUrl() {
        StringBuilder buf = new StringBuilder(URL_PREFIX.length() + 20);
        buf.append(URL_PREFIX).append(this.getType()).append("/").append(this.key).append("/").append(this.resourceName);
        this.delegate.addParamsToUrl(buf, this.delegate.getParams());
        return buf.toString();
    }

    @Override
    public Map<String, String> getParams() {
        return this.delegate.getParams();
    }

    @Override
    public String getVersion(WebResourceIntegration integration) {
        return this.hash;
    }

    @Override
    public String getType() {
        return this.delegate.getType();
    }

    @Override
    public boolean isCacheSupported() {
        return true;
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public String getModuleCompleteKey() {
        return "contextbatch-" + this.resourceName;
    }

    public String toString() {
        return "[Context Batch name=" + this.resourceName + ", type=" + this.getType() + ", params=" + this.getParams() + "]";
    }
}

