/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.transformer;

import com.atlassian.plugin.servlet.DownloadException;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.transformer.AbstractTransformedDownloadableResource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.IOUtils;

public abstract class AbstractStringTransformedDownloadableResource
extends AbstractTransformedDownloadableResource {
    public AbstractStringTransformedDownloadableResource(DownloadableResource originalResource) {
        super(originalResource);
    }

    public void streamResource(OutputStream out) throws DownloadException {
        ByteArrayOutputStream delegateOut = new ByteArrayOutputStream();
        this.getOriginalResource().streamResource(delegateOut);
        try {
            String originalContent = new String(delegateOut.toByteArray(), this.getEncoding());
            String transformedContent = this.transform(originalContent);
            IOUtils.copy((Reader)new StringReader(transformedContent.toString()), (OutputStream)out, (String)this.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new DownloadException(e);
        }
        catch (IOException e) {
            throw new DownloadException("Unable to stream to the output", e);
        }
    }

    protected String getEncoding() {
        return "UTF-8";
    }

    protected abstract String transform(String var1);
}

