/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.webresource.CssWebResource;
import com.atlassian.plugin.webresource.DefaultResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.DefaultResourceDependencyResolver;
import com.atlassian.plugin.webresource.DefaultWebResourceFilter;
import com.atlassian.plugin.webresource.JavascriptWebResource;
import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.ResourceDependencyResolver;
import com.atlassian.plugin.webresource.SuperBatchPluginResource;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceFilter;
import com.atlassian.plugin.webresource.WebResourceFormatter;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebResourceManagerImpl
implements WebResourceManager {
    private static final Logger log = LoggerFactory.getLogger(WebResourceManagerImpl.class);
    static final String STATIC_RESOURCE_PREFIX = "s";
    static final String STATIC_RESOURCE_SUFFIX = "_";
    static final String REQUEST_CACHE_RESOURCE_KEY = "plugin.webresource.names";
    protected final WebResourceIntegration webResourceIntegration;
    protected final PluginResourceLocator pluginResourceLocator;
    protected final ResourceBatchingConfiguration batchingConfiguration;
    protected final ResourceDependencyResolver dependencyResolver;
    protected static final List<WebResourceFormatter> webResourceFormatters = Arrays.asList(CssWebResource.FORMATTER, JavascriptWebResource.FORMATTER);
    private static final boolean IGNORE_SUPERBATCHING = false;
    @Deprecated
    private static final String REQUEST_CACHE_MODE_KEY = "plugin.webresource.mode";
    @Deprecated
    private static final WebResourceManager.IncludeMode DEFAULT_INCLUDE_MODE = WebResourceManager.DELAYED_INCLUDE_MODE;

    public WebResourceManagerImpl(PluginResourceLocator pluginResourceLocator, WebResourceIntegration webResourceIntegration) {
        this(pluginResourceLocator, webResourceIntegration, new DefaultResourceBatchingConfiguration());
    }

    public WebResourceManagerImpl(PluginResourceLocator pluginResourceLocator, WebResourceIntegration webResourceIntegration, ResourceBatchingConfiguration batchingConfiguration) {
        this(pluginResourceLocator, webResourceIntegration, batchingConfiguration, new DefaultResourceDependencyResolver(webResourceIntegration, batchingConfiguration));
    }

    public WebResourceManagerImpl(PluginResourceLocator pluginResourceLocator, WebResourceIntegration webResourceIntegration, ResourceBatchingConfiguration batchingConfiguration, ResourceDependencyResolver dependencyResolver) {
        this.pluginResourceLocator = pluginResourceLocator;
        this.webResourceIntegration = webResourceIntegration;
        this.batchingConfiguration = batchingConfiguration;
        this.dependencyResolver = dependencyResolver;
    }

    @Override
    public void requireResource(String moduleCompleteKey) {
        log.debug("Requiring resource: " + moduleCompleteKey);
        this.getIncludedResourceNames().addAll(this.dependencyResolver.getDependencies(moduleCompleteKey, this.batchingConfiguration.isSuperBatchingEnabled()));
    }

    @Override
    public void requireResourcesForContext(String context) {
        List webResourceModuleDescriptors = this.webResourceIntegration.getPluginAccessor().getEnabledModuleDescriptorsByClass(WebResourceModuleDescriptor.class);
        for (WebResourceModuleDescriptor webResourceModuleDescriptor : webResourceModuleDescriptors) {
            if (!webResourceModuleDescriptor.getContexts().contains(context)) continue;
            this.requireResource(webResourceModuleDescriptor.getCompleteKey());
        }
    }

    private LinkedHashSet<String> getIncludedResourceNames() {
        Map<String, Object> cache = this.webResourceIntegration.getRequestCache();
        LinkedHashSet webResourceNames = (LinkedHashSet)cache.get(REQUEST_CACHE_RESOURCE_KEY);
        if (webResourceNames == null) {
            webResourceNames = new LinkedHashSet();
            cache.put(REQUEST_CACHE_RESOURCE_KEY, webResourceNames);
        }
        return webResourceNames;
    }

    private void clearIncludedResourceNames() {
        log.debug("Clearing included resources");
        this.getIncludedResourceNames().clear();
    }

    @Override
    public void includeResources(Writer writer) {
        this.includeResources(writer, UrlMode.AUTO);
    }

    @Override
    public void includeResources(Iterable<String> moduleCompleteKeys, Writer writer, UrlMode urlMode) {
        LinkedHashSet<String> resources = new LinkedHashSet<String>();
        for (String moduleCompleteKey : moduleCompleteKeys) {
            LinkedHashSet<String> dependencies = this.dependencyResolver.getDependencies(moduleCompleteKey, false);
            resources.addAll(dependencies);
        }
        this.writeResourceTags(this.getModuleResources(resources, DefaultWebResourceFilter.INSTANCE), writer, urlMode);
    }

    @Override
    public void includeResources(Writer writer, UrlMode urlMode) {
        this.includeResources(writer, urlMode, DefaultWebResourceFilter.INSTANCE);
    }

    @Override
    public void includeResources(Writer writer, UrlMode urlMode, WebResourceFilter webResourceFilter) {
        this.writeIncludedResources(writer, urlMode, webResourceFilter);
        this.clearIncludedResourceNames();
    }

    @Override
    public String getRequiredResources() {
        return this.getRequiredResources(UrlMode.AUTO);
    }

    @Override
    public String getRequiredResources(UrlMode urlMode) {
        return this.getRequiredResources(urlMode, DefaultWebResourceFilter.INSTANCE);
    }

    @Override
    public String getRequiredResources(UrlMode urlMode, WebResourceFilter webResourceFilter) {
        StringWriter writer = new StringWriter();
        this.writeIncludedResources(writer, urlMode, webResourceFilter);
        return writer.toString();
    }

    private void writeIncludedResources(Writer writer, UrlMode urlMode, WebResourceFilter filter) {
        ArrayList<PluginResource> resourcesToInclude = new ArrayList<PluginResource>();
        resourcesToInclude.addAll(this.getSuperBatchResources(filter));
        resourcesToInclude.addAll(this.getModuleResources(this.getIncludedResourceNames(), filter));
        this.writeResourceTags(resourcesToInclude, writer, urlMode);
    }

    List<PluginResource> getSuperBatchResources(WebResourceFilter filter) {
        if (!this.batchingConfiguration.isSuperBatchingEnabled()) {
            return Collections.emptyList();
        }
        LinkedHashSet<String> superBatchModuleKeys = this.dependencyResolver.getSuperBatchDependencies();
        ArrayList<PluginResource> resources = new ArrayList<PluginResource>();
        for (WebResourceFormatter formatter : webResourceFormatters) {
            HashSet alreadyIncluded = new HashSet();
            for (String moduleKey : superBatchModuleKeys) {
                for (PluginResource pluginResource : this.pluginResourceLocator.getPluginResources(moduleKey)) {
                    if (!formatter.matches(pluginResource.getResourceName()) || !filter.matches(pluginResource.getResourceName())) continue;
                    HashMap<String, String> batchParamsMap = new HashMap<String, String>(PluginResourceLocator.BATCH_PARAMS.length);
                    for (String s : PluginResourceLocator.BATCH_PARAMS) {
                        batchParamsMap.put(s, pluginResource.getParams().get(s));
                    }
                    if (alreadyIncluded.contains(batchParamsMap)) continue;
                    resources.add(SuperBatchPluginResource.createBatchFor(pluginResource));
                    alreadyIncluded.add(batchParamsMap);
                }
            }
        }
        return resources;
    }

    private List<PluginResource> getModuleResources(LinkedHashSet<String> webResourcePluginModuleKeys, WebResourceFilter filter) {
        ArrayList<PluginResource> includedResources = new ArrayList<PluginResource>();
        for (String moduleKey : webResourcePluginModuleKeys) {
            List<PluginResource> moduleResources = this.pluginResourceLocator.getPluginResources(moduleKey);
            for (PluginResource moduleResource : moduleResources) {
                if (filter.matches(moduleResource.getResourceName())) {
                    includedResources.add(moduleResource);
                    continue;
                }
                log.debug("Resource [" + moduleResource.getResourceName() + "] excluded by filter");
            }
        }
        return includedResources;
    }

    private void writeResourceTags(List<PluginResource> resourcesToInclude, Writer writer, UrlMode urlMode) {
        for (WebResourceFormatter formatter : webResourceFormatters) {
            Iterator<PluginResource> iter = resourcesToInclude.iterator();
            while (iter.hasNext()) {
                PluginResource resource = iter.next();
                if (!formatter.matches(resource.getResourceName())) continue;
                this.writeResourceTag(urlMode, resource, formatter, writer);
                iter.remove();
            }
        }
        for (PluginResource resource : resourcesToInclude) {
            this.writeContentAndSwallowErrors("<!-- Error loading resource \"" + resource.getModuleCompleteKey() + "\".  No resource formatter matches \"" + resource.getResourceName() + "\" -->\n", writer);
        }
    }

    private void writeResourceTag(UrlMode urlMode, PluginResource resource, WebResourceFormatter formatter, Writer writer) {
        String url = resource.getUrl();
        url = resource.isCacheSupported() ? this.getStaticResourcePrefix(resource.getVersion(this.webResourceIntegration), urlMode) + url : this.webResourceIntegration.getBaseUrl(urlMode) + url;
        this.writeContentAndSwallowErrors(formatter.formatResource(url, resource.getParams()), writer);
    }

    @Override
    public void requireResource(String moduleCompleteKey, Writer writer) {
        this.requireResource(moduleCompleteKey, writer, UrlMode.AUTO);
    }

    @Override
    public void requireResource(String moduleCompleteKey, Writer writer, UrlMode urlMode) {
        LinkedHashSet<String> allDependentModuleKeys = this.dependencyResolver.getDependencies(moduleCompleteKey, false);
        List<PluginResource> resourcesToInclude = this.getModuleResources(allDependentModuleKeys, DefaultWebResourceFilter.INSTANCE);
        this.writeResourceTags(resourcesToInclude, writer, urlMode);
    }

    @Override
    public String getResourceTags(String moduleCompleteKey) {
        return this.getResourceTags(moduleCompleteKey, UrlMode.AUTO);
    }

    @Override
    public String getResourceTags(String moduleCompleteKey, UrlMode urlMode) {
        StringWriter writer = new StringWriter();
        this.requireResource(moduleCompleteKey, writer, urlMode);
        return writer.toString();
    }

    private void writeContentAndSwallowErrors(String content, Writer writer) {
        try {
            writer.write(content);
        }
        catch (IOException e) {
            log.debug("Ignoring", (Throwable)e);
        }
    }

    @Override
    public String getStaticResourcePrefix() {
        return this.getStaticResourcePrefix(UrlMode.AUTO);
    }

    @Override
    public String getStaticResourcePrefix(UrlMode urlMode) {
        return this.webResourceIntegration.getBaseUrl(urlMode) + "/" + STATIC_RESOURCE_PREFIX + "/" + this.webResourceIntegration.getSystemBuildNumber() + "/" + this.webResourceIntegration.getSystemCounter() + "/" + STATIC_RESOURCE_SUFFIX;
    }

    @Override
    public String getStaticResourcePrefix(String resourceCounter) {
        return this.getStaticResourcePrefix(resourceCounter, UrlMode.AUTO);
    }

    @Override
    public String getStaticResourcePrefix(String resourceCounter, UrlMode urlMode) {
        return this.webResourceIntegration.getBaseUrl(urlMode) + "/" + STATIC_RESOURCE_PREFIX + "/" + this.webResourceIntegration.getSystemBuildNumber() + "/" + this.webResourceIntegration.getSystemCounter() + "/" + resourceCounter + "/" + STATIC_RESOURCE_SUFFIX;
    }

    @Override
    public String getStaticPluginResource(String moduleCompleteKey, String resourceName) {
        return this.getStaticPluginResource(moduleCompleteKey, resourceName, UrlMode.AUTO);
    }

    @Override
    public String getStaticPluginResource(String moduleCompleteKey, String resourceName, UrlMode urlMode) {
        ModuleDescriptor moduleDescriptor = this.webResourceIntegration.getPluginAccessor().getEnabledPluginModule(moduleCompleteKey);
        if (moduleDescriptor == null) {
            return null;
        }
        return this.getStaticPluginResource(moduleDescriptor, resourceName, urlMode);
    }

    public String getStaticPluginResource(ModuleDescriptor moduleDescriptor, String resourceName) {
        return this.getStaticPluginResource(moduleDescriptor, resourceName, UrlMode.AUTO);
    }

    public String getStaticPluginResource(ModuleDescriptor moduleDescriptor, String resourceName, UrlMode urlMode) {
        String staticUrlPrefix = this.getStaticResourcePrefix(String.valueOf(moduleDescriptor.getPlugin().getPluginsVersion()), urlMode);
        return staticUrlPrefix + this.pluginResourceLocator.getResourceUrl(moduleDescriptor.getCompleteKey(), resourceName);
    }

    @Deprecated
    public String getStaticPluginResourcePrefix(ModuleDescriptor moduleDescriptor, String resourceName) {
        return this.getStaticPluginResource(moduleDescriptor, resourceName);
    }

    @Override
    @Deprecated
    public void setIncludeMode(WebResourceManager.IncludeMode includeMode) {
        this.webResourceIntegration.getRequestCache().put(REQUEST_CACHE_MODE_KEY, includeMode);
    }
}

