/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceDownloadUtils {
    private static final Logger log = LoggerFactory.getLogger(ResourceDownloadUtils.class);
    private static final long TEN_YEARS = 315360000000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void serveFileImpl(HttpServletResponse httpServletResponse, InputStream in) throws IOException {
        ServletOutputStream out = httpServletResponse.getOutputStream();
        try {
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            out.flush();
        }
        log.debug("Serving file done.");
    }

    public static void addCachingHeaders(HttpServletResponse httpServletResponse, String ... cacheControls) {
        if (!Boolean.getBoolean("atlassian.disable.caches")) {
            httpServletResponse.setDateHeader("Expires", System.currentTimeMillis() + 315360000000L);
            httpServletResponse.setHeader("Cache-Control", "max-age=315360000000");
            for (String cacheControl : cacheControls) {
                httpServletResponse.addHeader("Cache-Control", cacheControl);
            }
        }
    }

    @Deprecated
    public static void addCachingHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ResourceDownloadUtils.addPublicCachingHeaders(httpServletRequest, httpServletResponse);
    }

    public static void addPublicCachingHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ResourceDownloadUtils.addCachingHeaders(httpServletResponse, "public");
    }

    public static void addPrivateCachingHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ResourceDownloadUtils.addCachingHeaders(httpServletResponse, "private");
    }
}

