/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.webresource.CssWebResourceFormatter;
import com.atlassian.plugin.webresource.JavascriptWebResourceFormatter;
import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceFormatter;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebResourceManagerImpl
implements WebResourceManager {
    private static final Log log = LogFactory.getLog(WebResourceManagerImpl.class);
    static final String STATIC_RESOURCE_PREFIX = "s";
    static final String STATIC_RESOURCE_SUFFIX = "_";
    static final String REQUEST_CACHE_RESOURCE_KEY = "plugin.webresource.names";
    protected final WebResourceIntegration webResourceIntegration;
    protected final PluginResourceLocator pluginResourceLocator;
    protected static final List<WebResourceFormatter> webResourceFormatters = Arrays.asList(new CssWebResourceFormatter(), new JavascriptWebResourceFormatter());
    @Deprecated
    private static final String REQUEST_CACHE_MODE_KEY = "plugin.webresource.mode";

    public WebResourceManagerImpl(PluginResourceLocator pluginResourceLocator, WebResourceIntegration webResourceIntegration) {
        this.pluginResourceLocator = pluginResourceLocator;
        this.webResourceIntegration = webResourceIntegration;
    }

    @Override
    public void requireResource(String moduleCompleteKey) {
        log.debug((Object)("Requiring resource: " + moduleCompleteKey));
        LinkedHashSet<String> webResourceNames = this.getWebResourceNames();
        LinkedHashSet<String> resources = new LinkedHashSet<String>();
        this.addResourceWithDependencies(moduleCompleteKey, resources, new Stack<String>());
        webResourceNames.addAll(resources);
    }

    private LinkedHashSet<String> getWebResourceNames() {
        Map<String, Object> cache = this.webResourceIntegration.getRequestCache();
        LinkedHashSet webResourceNames = (LinkedHashSet)cache.get(REQUEST_CACHE_RESOURCE_KEY);
        if (webResourceNames == null) {
            webResourceNames = new LinkedHashSet();
            cache.put(REQUEST_CACHE_RESOURCE_KEY, webResourceNames);
        }
        return webResourceNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResourceWithDependencies(String moduleKey, LinkedHashSet<String> orderedResourceKeys, Stack<String> stack) {
        if (stack.contains(moduleKey)) {
            log.warn((Object)("Cyclic plugin resource dependency has been detected with: " + moduleKey + "\n" + "Stack trace: " + stack));
            return;
        }
        ModuleDescriptor moduleDescriptor = this.webResourceIntegration.getPluginAccessor().getEnabledPluginModule(moduleKey);
        if (!(moduleDescriptor instanceof WebResourceModuleDescriptor)) {
            log.warn((Object)("Cannot find web resource module for: " + moduleKey));
            return;
        }
        List<String> dependencies = ((WebResourceModuleDescriptor)moduleDescriptor).getDependencies();
        log.debug((Object)("About to add resource [" + moduleKey + "] and its dependencies: " + dependencies));
        stack.push(moduleKey);
        try {
            for (String dependency : dependencies) {
                if (orderedResourceKeys.contains(dependency)) continue;
                this.addResourceWithDependencies(dependency, orderedResourceKeys, stack);
            }
        }
        finally {
            stack.pop();
        }
        orderedResourceKeys.add(moduleKey);
    }

    @Override
    public void includeResources(Writer writer) {
        this.includeResources(writer, UrlMode.AUTO);
    }

    @Override
    public void includeResources(Writer writer, UrlMode urlMode) {
        this.includeResources(writer, true, urlMode);
    }

    @Override
    public String getRequiredResources() {
        return this.getRequiredResources(UrlMode.AUTO);
    }

    @Override
    public String getRequiredResources(UrlMode urlMode) {
        StringWriter writer = new StringWriter();
        this.includeResources(writer, false, urlMode);
        return writer.toString();
    }

    private void includeResources(Writer writer, boolean clearResources, UrlMode urlMode) {
        LinkedHashSet<String> webResourceNames = this.getWebResourceNames();
        if (webResourceNames == null || webResourceNames.isEmpty()) {
            log.debug((Object)"No resources required to write");
            return;
        }
        Iterator i$ = webResourceNames.iterator();
        while (i$.hasNext()) {
            String webResourceName;
            String resourceName = webResourceName = (String)i$.next();
            this.writeResourceTag(resourceName, writer, urlMode);
        }
        if (clearResources) {
            webResourceNames.clear();
        }
    }

    @Override
    public void requireResource(String moduleCompleteKey, Writer writer) {
        this.requireResource(moduleCompleteKey, writer, UrlMode.AUTO);
    }

    @Override
    public void requireResource(String moduleCompleteKey, Writer writer, UrlMode urlMode) {
        LinkedHashSet<String> resourcesWithDeps = new LinkedHashSet<String>();
        this.addResourceWithDependencies(moduleCompleteKey, resourcesWithDeps, new Stack<String>());
        for (String resource : resourcesWithDeps) {
            this.writeResourceTag(resource, writer, urlMode);
        }
    }

    private void writeResourceTag(String moduleCompleteKey, Writer writer, UrlMode urlMode) {
        List<PluginResource> resources = this.pluginResourceLocator.getPluginResources(moduleCompleteKey);
        if (resources == null) {
            this.writeContentAndSwallowErrors("<!-- Error loading resource \"" + moduleCompleteKey + "\".  Resource not found -->\n", writer);
            return;
        }
        for (PluginResource resource : resources) {
            WebResourceFormatter formatter = this.getWebResourceFormatter(resource.getResourceName());
            if (formatter == null) {
                this.writeContentAndSwallowErrors("<!-- Error loading resource \"" + moduleCompleteKey + "\".  Resource formatter not found -->\n", writer);
                continue;
            }
            String url = resource.getUrl();
            if (resource.isCacheSupported()) {
                Plugin plugin = this.webResourceIntegration.getPluginAccessor().getEnabledPluginModule(resource.getModuleCompleteKey()).getPlugin();
                url = this.getStaticResourcePrefix(plugin.getPluginInformation().getVersion(), urlMode) + url;
            } else {
                url = this.webResourceIntegration.getBaseUrl(urlMode) + url;
            }
            this.writeContentAndSwallowErrors(formatter.formatResource(url, resource.getParams()), writer);
        }
    }

    @Override
    public String getResourceTags(String moduleCompleteKey) {
        return this.getResourceTags(moduleCompleteKey, UrlMode.AUTO);
    }

    @Override
    public String getResourceTags(String moduleCompleteKey, UrlMode urlMode) {
        StringWriter writer = new StringWriter();
        this.requireResource(moduleCompleteKey, writer, urlMode);
        return writer.toString();
    }

    private void writeContentAndSwallowErrors(String content, Writer writer) {
        try {
            writer.write(content);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    private WebResourceFormatter getWebResourceFormatter(String resourceName) {
        for (WebResourceFormatter webResourceFormatter : webResourceFormatters) {
            if (!webResourceFormatter.matches(resourceName)) continue;
            return webResourceFormatter;
        }
        return null;
    }

    @Override
    public String getStaticResourcePrefix() {
        return this.getStaticResourcePrefix(UrlMode.AUTO);
    }

    @Override
    public String getStaticResourcePrefix(UrlMode urlMode) {
        return this.webResourceIntegration.getBaseUrl(urlMode) + "/" + STATIC_RESOURCE_PREFIX + "/" + this.webResourceIntegration.getSystemBuildNumber() + "/" + this.webResourceIntegration.getSystemCounter() + "/" + STATIC_RESOURCE_SUFFIX;
    }

    @Override
    public String getStaticResourcePrefix(String resourceCounter) {
        return this.getStaticResourcePrefix(resourceCounter, UrlMode.AUTO);
    }

    @Override
    public String getStaticResourcePrefix(String resourceCounter, UrlMode urlMode) {
        return this.webResourceIntegration.getBaseUrl(urlMode) + "/" + STATIC_RESOURCE_PREFIX + "/" + this.webResourceIntegration.getSystemBuildNumber() + "/" + this.webResourceIntegration.getSystemCounter() + "/" + resourceCounter + "/" + STATIC_RESOURCE_SUFFIX;
    }

    @Override
    public String getStaticPluginResource(String moduleCompleteKey, String resourceName) {
        return this.getStaticPluginResource(moduleCompleteKey, resourceName, UrlMode.AUTO);
    }

    @Override
    public String getStaticPluginResource(String moduleCompleteKey, String resourceName, UrlMode urlMode) {
        ModuleDescriptor moduleDescriptor = this.webResourceIntegration.getPluginAccessor().getEnabledPluginModule(moduleCompleteKey);
        if (moduleDescriptor == null) {
            return null;
        }
        return this.getStaticPluginResource(moduleDescriptor, resourceName, urlMode);
    }

    @Override
    public String getStaticPluginResource(ModuleDescriptor<?> moduleDescriptor, String resourceName) {
        return this.getStaticPluginResource(moduleDescriptor, resourceName, UrlMode.AUTO);
    }

    @Override
    public String getStaticPluginResource(ModuleDescriptor<?> moduleDescriptor, String resourceName, UrlMode urlMode) {
        String staticUrlPrefix = this.getStaticResourcePrefix(String.valueOf(moduleDescriptor.getPlugin().getPluginsVersion()), urlMode);
        return staticUrlPrefix + this.pluginResourceLocator.getResourceUrl(moduleDescriptor.getCompleteKey(), resourceName);
    }

    @Deprecated
    public String getStaticPluginResourcePrefix(ModuleDescriptor moduleDescriptor, String resourceName) {
        return this.getStaticPluginResource(moduleDescriptor, resourceName);
    }

    @Override
    @Deprecated
    public void setIncludeMode(WebResourceManager.IncludeMode includeMode) {
        this.webResourceIntegration.getRequestCache().put(REQUEST_CACHE_MODE_KEY, includeMode);
    }
}

