/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.servlet.DownloadException;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.PluginResource;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchPluginResource
implements DownloadableResource,
PluginResource {
    private static final Log log = LogFactory.getLog(BatchPluginResource.class);
    static final String URL_PREFIX = "/download/batch";
    private final String type;
    private final String moduleCompleteKey;
    private final Map<String, String> params;
    private final String resourceName;
    private final List<DownloadableResource> resources;

    public BatchPluginResource(String moduleCompleteKey, String type, Map<String, String> params) {
        this(moduleCompleteKey + "." + type, moduleCompleteKey, type, params);
    }

    private BatchPluginResource(String resourceName, String moduleCompleteKey, String type, Map<String, String> params) {
        this.resourceName = resourceName;
        this.moduleCompleteKey = moduleCompleteKey;
        this.type = type;
        this.params = params;
        this.resources = new ArrayList<DownloadableResource>();
    }

    public boolean isEmpty() {
        return this.resources.isEmpty();
    }

    public void add(DownloadableResource resource) {
        this.resources.add(resource);
    }

    @Override
    public boolean isResourceModified(HttpServletRequest request, HttpServletResponse response) {
        for (DownloadableResource resource : this.resources) {
            if (!resource.isResourceModified(request, response)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void serveResource(HttpServletRequest request, HttpServletResponse response) throws DownloadException {
        log.debug((Object)("Start to serve batch " + this.toString()));
        for (DownloadableResource resource : this.resources) {
            resource.serveResource(request, response);
        }
    }

    @Override
    public void streamResource(OutputStream out) {
        for (DownloadableResource resource : this.resources) {
            resource.streamResource(out);
        }
    }

    @Override
    public String getContentType() {
        String contentType = this.params.get("content-type");
        if (contentType != null) {
            return contentType;
        }
        return null;
    }

    public static BatchPluginResource parse(String url, Map<String, String> queryParams) {
        String typeAndModuleKey;
        String[] parts;
        int startIndex = url.indexOf(URL_PREFIX) + URL_PREFIX.length() + 1;
        if (url.indexOf(63) != -1) {
            url = url.substring(0, url.indexOf(63));
        }
        if ((parts = (typeAndModuleKey = url.substring(startIndex)).split("/", 2)).length < 2) {
            return null;
        }
        String moduleKey = parts[0];
        String resourceName = parts[1];
        String type = resourceName.substring(resourceName.lastIndexOf(46) + 1);
        return new BatchPluginResource(resourceName, moduleKey, type, queryParams);
    }

    public static boolean matches(String url) {
        return url.indexOf(URL_PREFIX) != -1;
    }

    @Override
    public String getUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append(URL_PREFIX).append("/").append(this.moduleCompleteKey).append("/").append(this.resourceName);
        if (this.params.size() > 0) {
            sb.append("?");
            int count = 0;
            for (Map.Entry<String, String> entry : this.params.entrySet()) {
                sb.append(entry.getKey()).append("=").append(entry.getValue());
                if (++count >= this.params.size()) continue;
                sb.append("&");
            }
        }
        return sb.toString();
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public Map<String, String> getParams() {
        return Collections.unmodifiableMap(this.params);
    }

    @Override
    public String getModuleCompleteKey() {
        return this.moduleCompleteKey;
    }

    @Override
    public boolean isCacheSupported() {
        return !"false".equals(this.params.get("cache"));
    }

    public String getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchPluginResource that = (BatchPluginResource)o;
        if (this.moduleCompleteKey != null ? !this.moduleCompleteKey.equals(that.moduleCompleteKey) : that.moduleCompleteKey != null) {
            return false;
        }
        if (this.params != null ? !((Object)this.params).equals(that.params) : that.params != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.moduleCompleteKey != null ? this.moduleCompleteKey.hashCode() : 0);
        result = 31 * result + (this.params != null ? ((Object)this.params).hashCode() : 0);
        return result;
    }

    public String toString() {
        return "[moduleCompleteKey=" + this.moduleCompleteKey + ", type=" + this.type + ", params=" + this.params + "]";
    }
}

