/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.webresource.BatchedWebResourceDescriptor;
import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.ResourceKey;
import com.atlassian.plugin.webresource.ResourceUtils;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ContextBatchPluginResource
implements PluginResource {
    static final String URL_PREFIX = "/download/contextbatch/";
    private final ResourceKey resource;
    private final String key;
    private final String hash;
    private final List<String> contexts;
    private final Iterable<String> excludedContexts;
    private final Map<String, String> params;
    private final Set<BatchedWebResourceDescriptor> batchedWebResourceDescriptors;

    ContextBatchPluginResource(String key, List<String> contexts, Iterable<String> excludedContexts, String hash, String type, Map<String, String> params, Set<BatchedWebResourceDescriptor> batchedWebResourceDescriptor) {
        this.resource = ResourceKey.Builder.batch(type);
        this.params = ImmutableMap.copyOf(params);
        this.key = key;
        this.hash = hash;
        this.contexts = contexts;
        this.excludedContexts = excludedContexts;
        this.batchedWebResourceDescriptors = Collections.unmodifiableSet(batchedWebResourceDescriptor);
    }

    ContextBatchPluginResource(String key, String hash, String type, Map<String, String> params, Set<BatchedWebResourceDescriptor> batchedWebResourceDescriptor) {
        this(key, Collections.emptyList(), Collections.emptyList(), hash, type, params, batchedWebResourceDescriptor);
    }

    Iterable<String> getContexts() {
        return this.contexts;
    }

    public Iterable<String> getExcludedContexts() {
        return this.excludedContexts;
    }

    @Override
    public String getUrl() {
        StringBuilder buf = new StringBuilder(URL_PREFIX.length() + 20);
        buf.append(URL_PREFIX).append(this.getType()).append("/").append(this.key).append("/").append(this.getResourceName());
        ResourceUtils.addParamsToUrl(buf, this.getParams());
        return buf.toString();
    }

    @Override
    public Map<String, String> getParams() {
        return this.params;
    }

    @Override
    public String getVersion(WebResourceIntegration integration) {
        return this.hash;
    }

    @Override
    public String getType() {
        return this.resource.suffix();
    }

    @Override
    public boolean isCacheSupported() {
        return true;
    }

    @Override
    public String getResourceName() {
        return this.resource.name();
    }

    @Override
    public String getModuleCompleteKey() {
        return "contextbatch-" + this.resource.name();
    }

    @Override
    public Set<BatchedWebResourceDescriptor> getBatchedWebResourceDescriptors() {
        return this.batchedWebResourceDescriptors;
    }

    public String toString() {
        return "[Context Batch type=" + this.getType() + ", params=" + this.params + "]";
    }
}

