/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.webresource.BatchedWebResourceDescriptor;
import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.ResourceKey;
import com.atlassian.plugin.webresource.ResourceUtils;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;

public class BatchPluginResource
implements PluginResource {
    static final String URL_PREFIX = "/download/batch";
    private final ResourceKey resource;
    private final Map<String, String> params;
    private int hash = 0;
    private final BatchedWebResourceDescriptor batchedWebResourceDescriptor;

    BatchPluginResource(ResourceKey resource, Map<String, String> params, BatchedWebResourceDescriptor batchedWebResourceDescriptor) {
        this.resource = resource;
        this.params = ImmutableMap.copyOf(params);
        this.batchedWebResourceDescriptor = batchedWebResourceDescriptor;
    }

    @Override
    public String getUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append(URL_PREFIX).append("/").append(this.resource.key()).append("/").append(this.resource.name());
        ResourceUtils.addParamsToUrl(sb, this.params);
        return sb.toString();
    }

    @Override
    public String getResourceName() {
        return this.resource.name();
    }

    @Override
    public Map<String, String> getParams() {
        return this.params;
    }

    @Override
    public String getVersion(WebResourceIntegration integration) {
        Plugin plugin = integration.getPluginAccessor().getEnabledPluginModule(this.getModuleCompleteKey()).getPlugin();
        return plugin.getPluginInformation().getVersion();
    }

    @Override
    public String getModuleCompleteKey() {
        return this.resource.key();
    }

    @Override
    public boolean isCacheSupported() {
        return !"false".equals(this.params.get("cache"));
    }

    @Override
    public String getType() {
        return this.resource.suffix();
    }

    @Override
    public Set<BatchedWebResourceDescriptor> getBatchedWebResourceDescriptors() {
        return ImmutableSet.of((Object)this.batchedWebResourceDescriptor);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchPluginResource that = (BatchPluginResource)o;
        if (this.params != null ? !((Object)this.params).equals(that.params) : that.params != null) {
            return false;
        }
        return this.resource.equals(that.resource);
    }

    public int hashCode() {
        if (this.hash == 0) {
            int result = this.resource.hashCode();
            this.hash = result = 31 * result + (this.params != null ? ((Object)this.params).hashCode() : 0);
        }
        return this.hash;
    }

    public String toString() {
        return "[moduleCompleteKey=" + this.resource.key() + ", type=" + this.resource.suffix() + ", params=" + this.params + "]";
    }
}

