/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.conditions.ConditionLoadingException;
import com.atlassian.plugin.web.descriptors.ConditionElementParser;
import com.atlassian.plugin.web.descriptors.ConditionalDescriptor;
import com.atlassian.plugin.webresource.WebResourceTransformation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class WebResourceModuleDescriptor
extends AbstractModuleDescriptor<Void>
implements ConditionalDescriptor {
    private List<String> dependencies = Collections.emptyList();
    private boolean disableMinification;
    private Set<String> contexts = Collections.emptySet();
    private List<WebResourceTransformation> webResourceTransformations = Collections.emptyList();
    private ConditionElementParser conditionElementParser;
    private Element element;
    private Condition condition;

    public WebResourceModuleDescriptor(final HostContainer hostContainer) {
        this.conditionElementParser = new ConditionElementParser(new ConditionElementParser.ConditionFactory(){

            public Condition create(String className, Plugin plugin) throws ConditionLoadingException {
                try {
                    Class conditionClass = plugin.loadClass(className, this.getClass());
                    return (Condition)hostContainer.create(conditionClass);
                }
                catch (ClassNotFoundException e) {
                    throw new ConditionLoadingException("Cannot load condition class: " + className, (Throwable)e);
                }
            }
        });
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        ArrayList<String> deps = new ArrayList<String>();
        for (Element dependency : element.elements("dependency")) {
            deps.add(dependency.getTextTrim());
        }
        this.dependencies = Collections.unmodifiableList(deps);
        HashSet<String> ctxs = new HashSet<String>();
        for (Element contextElement : element.elements("context")) {
            ctxs.add(contextElement.getTextTrim());
        }
        this.contexts = Collections.unmodifiableSet(ctxs);
        ArrayList<WebResourceTransformation> trans = new ArrayList<WebResourceTransformation>();
        for (Element e : element.elements("transformation")) {
            trans.add(new WebResourceTransformation(e));
        }
        this.webResourceTransformations = Collections.unmodifiableList(trans);
        Attribute minifiedAttribute = element.attribute("disable-minification");
        this.disableMinification = minifiedAttribute == null ? false : Boolean.valueOf(minifiedAttribute.getValue());
        this.element = element;
    }

    public Void getModule() {
        throw new UnsupportedOperationException("There is no module for Web Resources");
    }

    public void enabled() {
        super.enabled();
        try {
            this.condition = this.conditionElementParser.makeConditions(this.plugin, this.element, 1);
        }
        catch (PluginParseException e) {
            throw new RuntimeException("Unable to enable web resource due to issue processing condition", e);
        }
    }

    public void disabled() {
        super.disabled();
        this.condition = null;
    }

    public Set<String> getContexts() {
        return this.contexts;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public List<WebResourceTransformation> getTransformations() {
        return this.webResourceTransformations;
    }

    public boolean isDisableMinification() {
        return this.disableMinification;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public boolean shouldDisplay() {
        return this.condition != null ? this.condition.shouldDisplay(Collections.emptyMap()) : true;
    }
}

