package com.atlassian.webresource.spi;

import javax.annotation.Nonnull;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.stream.Stream;

import static java.nio.charset.StandardCharsets.UTF_8;
import static java.util.Optional.ofNullable;

/**
 * SPI for resource compiler (minifier). Being used by atlassian-plugins-webresource MinificationTransformer.
 *
 * @since v3.5.10
 */
public interface ResourceCompiler {

    /**
     * Compiles/minifies provided {@link Stream} of resources' entries.
     *
     * @param entries - resources entries to minify.
     */
    void compile(@Nonnull final Stream<CompilerEntry> entries);

    /**
     * Provides compiled/minified contents of the resource under provided key.
     *
     * @param key - wanted resource's ID (can be a path).
     * @return compiled code
     */
    String content(@Nonnull final String key);

    default Optional<InputStream> toInputStream(final String key) {
        return ofNullable(this.content(key))
                .map(content -> new ByteArrayInputStream(content.getBytes(UTF_8)));
    }
}
