/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webresource.plugin.rest;

import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.impl.Globals;
import com.atlassian.plugin.webresource.impl.config.Config;
import com.atlassian.plugin.webresource.impl.snapshot.Bundle;
import com.atlassian.plugin.webresource.impl.snapshot.RootPage;
import com.atlassian.plugin.webresource.prebake.DimensionUnawareOverride;
import com.atlassian.plugin.webresource.prebake.PrebakeWebResourceAssemblerFactory;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.webresource.api.prebake.Dimensions;
import com.atlassian.webresource.plugin.prebake.discovery.PreBakeState;
import com.atlassian.webresource.plugin.prebake.discovery.RootPageCrawler;
import com.atlassian.webresource.plugin.prebake.discovery.SuperBatchCrawler;
import com.atlassian.webresource.plugin.prebake.discovery.WebResourcePreBaker;
import com.atlassian.webresource.plugin.prebake.resources.HttpResourceCollector;
import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnonymousAllowed
@Path(value="prebake")
public final class PreBakeResource {
    private static final Logger log = LoggerFactory.getLogger(PreBakeResource.class);
    private final WebResourcePreBaker preBaker;
    private final PrebakeWebResourceAssemblerFactory webResourceAssemblerFactory;
    private final Config config;
    private final Globals globals;
    @Context
    @VisibleForTesting
    UriInfo info;

    public PreBakeResource(WebResourceIntegration webResourceIntegration, PrebakeWebResourceAssemblerFactory webResourceAssemblerFactory, PluginResourceLocator pluginResourceLocator) {
        this(pluginResourceLocator.temporaryWayToGetGlobalsDoNotUseIt().getConfig(), pluginResourceLocator.temporaryWayToGetGlobalsDoNotUseIt(), webResourceIntegration, webResourceAssemblerFactory);
    }

    @VisibleForTesting
    PreBakeResource(Config config, Globals globals, WebResourceIntegration webResourceIntegration, PrebakeWebResourceAssemblerFactory webResourceAssemblerFactory) {
        this.globals = globals;
        this.config = config;
        this.webResourceAssemblerFactory = webResourceAssemblerFactory;
        this.preBaker = new WebResourcePreBaker(config, webResourceIntegration, new HttpResourceCollector());
    }

    @Path(value="/state")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public final Response put(PreBakeRequest request) {
        return this.whenPreBakeIsEnabled(() -> {
            SuperBatchCrawler crawler = new SuperBatchCrawler(this.webResourceAssemblerFactory, this.toDimensions(request.dimensionValueWhitelist));
            WebResourcePreBaker.PreBakeStatus status = this.preBaker.start(crawler);
            return Response.ok((Object)new PreBakeResult(status)).build();
        });
    }

    @Path(value="/start")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public final Response prebakeRootPages(PreBakeRequest request) {
        return this.whenPreBakeIsEnabled(() -> this.startRootPagePrebake(request));
    }

    private Response startRootPagePrebake(PreBakeRequest request) {
        ValidatedRootPages validatedRootPages = PreBakeResource.getValidatedRootPages(request.pagesToPrebake, this.globals.getSnapshot().getAllRootPages());
        if (CollectionUtils.isNotEmpty(validatedRootPages.invalidRootPageNames)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ValidatedRootPagesREST(validatedRootPages)).build();
        }
        this.setupDimensionUnawareOverrides(request.dimensionUnawareOverrides);
        RootPageCrawler rootPageCrawler = new RootPageCrawler(this.webResourceAssemblerFactory, validatedRootPages.includedRootPages, this.toDimensions(request.dimensionValueWhitelist));
        WebResourcePreBaker.PreBakeStatus status = this.preBaker.start(rootPageCrawler);
        return Response.ok((Object)new PreBakeResult(status)).build();
    }

    private void setupDimensionUnawareOverrides(Map<String, DimensionOverrideRequest> overrides) {
        if (overrides == null || overrides.isEmpty()) {
            DimensionUnawareOverride.reset();
            return;
        }
        ArrayList<DimensionUnawareOverride.DimensionOverride> os = new ArrayList<DimensionUnawareOverride.DimensionOverride>();
        for (String className : overrides.keySet()) {
            DimensionOverrideRequest dor = overrides.get(className);
            os.add(new DimensionUnawareOverride.DimensionOverride(className, dor.key, dor.dimensions));
        }
        DimensionUnawareOverride.setup(os);
    }

    private Dimensions toDimensions(Map<String, List<String>> rawDimensions) {
        if (rawDimensions == null) {
            return Dimensions.empty();
        }
        return Dimensions.fromMap(rawDimensions);
    }

    @Path(value="/dimensions")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public final Response rootPageDimensions(PreBakeRequest request) {
        return this.whenPreBakeIsEnabled(() -> {
            ValidatedRootPages validatedRootPages = PreBakeResource.getValidatedRootPages(request.pagesToPrebake, this.globals.getSnapshot().getAllRootPages());
            if (CollectionUtils.isNotEmpty(validatedRootPages.invalidRootPageNames)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ValidatedRootPagesREST(validatedRootPages)).build();
            }
            LinkedHashMap rootPageDimensions = new LinkedHashMap();
            Dimensions whiteList = this.toDimensions(request.dimensionValueWhitelist);
            validatedRootPages.includedRootPages.stream().map(RootPage::getWebResource).forEach(wr -> {
                Dimensions dims = this.webResourceAssemblerFactory.computeBundleDimensions((Bundle)wr).whitelistValues(whiteList);
                rootPageDimensions.put(wr.getKey(), dims.toString() + " Cartesian product: " + dims.cartesianProduct().count());
            });
            return Response.ok(rootPageDimensions).build();
        });
    }

    @Path(value="/state")
    @GET
    @Produces(value={"application/json"})
    public final Response get() {
        return this.whenPreBakeIsEnabled(() -> Response.ok((Object)new PreBakeResult(this.preBaker.getStatus())).build());
    }

    @Path(value="/bundle.zip")
    @GET
    @Produces(value={"application/octet-stream"})
    public final Response bundle() {
        return this.whenPreBakeIsEnabled(() -> {
            WebResourcePreBaker.PreBakeStatus status = this.preBaker.getStatus();
            if (PreBakeState.DONE == status.getState()) {
                return Response.ok((Object)status.getBundlePath().toFile()).header("Content-Disposition", (Object)"attachment; filename=bundle.zip").build();
            }
            log.debug("Bundle is not ready, current state is [{}]", (Object)status.getState());
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        });
    }

    private Response whenPreBakeIsEnabled(Supplier<Response> normalResponse) {
        if (this.config.isPreBakeEnabled()) {
            return normalResponse.get();
        }
        log.warn("Pre-baking called but feature is not enabled!");
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @VisibleForTesting
    static ValidatedRootPages getValidatedRootPages(List<String> rootPageNames, Iterable<RootPage> rootPages) {
        if (CollectionUtils.isEmpty(rootPageNames)) {
            log.debug("Provided list of root pages is empty, will return all known root pages.");
            return new ValidatedRootPages(rootPages);
        }
        LinkedHashSet<RootPage> includedRootPages = new LinkedHashSet<RootPage>();
        LinkedHashSet<String> validRootPageNames = new LinkedHashSet<String>();
        for (RootPage rp : rootPages) {
            if (!rootPageNames.contains(rp.getWebResource().getKey())) continue;
            includedRootPages.add(rp);
            validRootPageNames.add(rp.getWebResource().getKey());
        }
        Collection invalidRootPageNames = CollectionUtils.disjunction(rootPageNames, validRootPageNames);
        return new ValidatedRootPages(invalidRootPageNames, validRootPageNames, includedRootPages);
    }

    public static class ValidatedRootPagesREST {
        public final Collection<String> validRootPageNames;
        public final Collection<String> invalidRootPageNames;

        public ValidatedRootPagesREST(ValidatedRootPages validatedRootPages) {
            this.validRootPageNames = validatedRootPages.validRootPageNames;
            this.invalidRootPageNames = validatedRootPages.invalidRootPageNames;
        }
    }

    public static class ValidatedRootPages {
        public final Collection<String> invalidRootPageNames;
        public final Collection<String> validRootPageNames;
        public final Collection<RootPage> includedRootPages;

        public ValidatedRootPages(Iterable<RootPage> rootPages) {
            this.invalidRootPageNames = new ArrayList<String>();
            this.validRootPageNames = StreamSupport.stream(rootPages.spliterator(), false).map(RootPage::getWebResource).map(Bundle::getKey).collect(Collectors.toList());
            this.includedRootPages = StreamSupport.stream(rootPages.spliterator(), false).collect(Collectors.toList());
        }

        public ValidatedRootPages(Collection<String> invalidRootPagesName, Collection<String> validRootPageNames, Collection<RootPage> includedRootPages) {
            this.invalidRootPageNames = invalidRootPagesName;
            this.validRootPageNames = validRootPageNames;
            this.includedRootPages = includedRootPages;
        }
    }

    public class PreBakeResult {
        public PreBakeState state;
        public String bundle;
        public String productStateHash;
        public Collection<String> targets;
        public int taintedResourcesCount;

        public PreBakeResult() {
            this.state = null;
            this.bundle = null;
            this.productStateHash = null;
            this.targets = null;
            this.taintedResourcesCount = 0;
        }

        public PreBakeResult(WebResourcePreBaker.PreBakeStatus status) {
            this.state = status.getState();
            this.bundle = "" + URI.create(PreBakeResource.this.info.getBaseUri() + "/prebake/bundle.zip").normalize();
            this.productStateHash = status.getGlobalStateHash();
            this.targets = status.getTargets();
            this.taintedResourcesCount = status.getTaintedResourceCount();
        }
    }

    public static class DimensionOverrideRequest {
        public String key;
        public List<String> dimensions;
    }

    public static class PreBakeRequest {
        public Map<String, List<String>> dimensionValueWhitelist;
        public Map<String, DimensionOverrideRequest> dimensionUnawareOverrides;
        public List<String> pagesToPrebake;
    }
}

