/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webresource.plugin.prebake.resources;

import com.atlassian.webresource.api.assembler.resource.PrebakeError;
import com.atlassian.webresource.plugin.prebake.resources.Resource;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GenericUrlResource
extends Resource {
    private static final Logger log = LoggerFactory.getLogger(GenericUrlResource.class);
    private static final Pattern extensionPattern = Pattern.compile(".*(?<extension>\\.[a-zA-Z-0-9]*).*$");
    private final String url;
    private final String extension;
    private final List<PrebakeError> errors;

    public GenericUrlResource(String url) {
        this(url, Collections.emptyList());
    }

    public GenericUrlResource(String url, List<PrebakeError> errors) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)url), (Object)"Empty URL");
        this.url = url;
        this.errors = errors;
        Matcher m = extensionPattern.matcher(url);
        if (m.matches()) {
            this.extension = m.group("extension");
        } else {
            log.warn("Resource with URL '{}' does not contain a valid extension", (Object)url);
            this.extension = "";
        }
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public boolean isTainted() {
        return !this.errors.isEmpty();
    }

    @Override
    public List<PrebakeError> getPrebakeErrors() {
        return this.errors;
    }

    @Override
    public String getName() {
        return this.url;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }
}

