/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webresource.plugin.rest;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.webresource.plugin.async.AsyncWebResourceLoader;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@AnonymousAllowed
@Path(value="resources")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ListOfResources {
    private final AsyncWebResourceLoader asyncWebResourceLoader;

    public ListOfResources(AsyncWebResourceLoader asyncWebResourceLoader) {
        this.asyncWebResourceLoader = asyncWebResourceLoader;
    }

    @GET
    public AsyncWebResourceLoader.ResourcesAndData get(@QueryParam(value="r") String webResources, @QueryParam(value="c") String contexts, @QueryParam(value="xr") String excludeResources, @QueryParam(value="xc") String excludeContexts) throws IOException {
        return this.asyncWebResourceLoader.resolve(this.asSet(webResources), this.asSet(contexts), this.asSet(excludeResources), this.asSet(excludeContexts));
    }

    @POST
    public AsyncWebResourceLoader.ResourcesAndData post(Request request) throws IOException {
        return this.asyncWebResourceLoader.resolve(this.asSet(request.resources), this.asSet(request.contexts), this.asSet(request.excludeResources), this.asSet(request.excludeContexts));
    }

    private Set<String> asSet(String str) {
        if (null == str || "".equals(str)) {
            return Collections.emptySet();
        }
        return Sets.newLinkedHashSet(Arrays.asList(str.split(",")));
    }

    private Set<String> asSet(List<String> list) {
        return Sets.newLinkedHashSet(list);
    }

    @XmlRootElement
    static class Request {
        @XmlAttribute(name="r")
        public List<String> resources;
        @XmlAttribute(name="c")
        public List<String> contexts;
        @XmlAttribute(name="xr")
        public List<String> excludeResources;
        @XmlAttribute(name="xc")
        public List<String> excludeContexts;

        public Request() {
        }

        public Request(List<String> resources, List<String> contexts, List<String> excludeResources, List<String> excludeContexts) {
            this.resources = resources;
            this.contexts = contexts;
            this.excludeResources = excludeResources;
            this.excludeContexts = excludeContexts;
        }
    }
}

