/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webresource.plugin.prebake.discovery;

import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.impl.config.Config;
import com.atlassian.plugin.webresource.prebake.PrebakeWebResourceAssemblerFactory;
import com.atlassian.util.concurrent.ThreadFactories;
import com.atlassian.webresource.plugin.prebake.discovery.DefaultWebResourceBatch;
import com.atlassian.webresource.plugin.prebake.discovery.DiscoveryTask;
import com.atlassian.webresource.plugin.prebake.discovery.PreBakeState;
import com.atlassian.webresource.plugin.prebake.discovery.WebResourceBatch;
import com.atlassian.webresource.plugin.prebake.discovery.WebResourceCrawler;
import com.atlassian.webresource.plugin.prebake.resources.ResourceCollector;
import com.atlassian.webresource.plugin.prebake.util.ConcurrentUtil;
import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebResourcePreBaker {
    private static final Logger log = LoggerFactory.getLogger(WebResourcePreBaker.class);
    private final ExecutorService pool;
    private final Lock readState;
    private final Lock writeState;
    private volatile PreBakeState state;
    private final WebResourceBatch batch;
    private final Config config;
    private final WebResourceIntegration webResourceIntegration;
    private final PrebakeWebResourceAssemblerFactory webResourceAssemblerFactory;
    private final ResourceCollector resourceCollector;

    public WebResourcePreBaker(Config config, WebResourceIntegration webResourceIntegration, PrebakeWebResourceAssemblerFactory webResourceAssemblerFactory, ResourceCollector resourceCollector) {
        this(config, webResourceIntegration, webResourceAssemblerFactory, new DefaultWebResourceBatch(webResourceAssemblerFactory.computeGlobalStateHash()), resourceCollector);
    }

    public WebResourcePreBaker(Config config, WebResourceIntegration webResourceIntegration, PrebakeWebResourceAssemblerFactory webResourceAssemblerFactory, WebResourceBatch batch, ResourceCollector resourceCollector) {
        ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
        this.readState = rwl.readLock();
        this.writeState = rwl.writeLock();
        this.pool = Executors.newSingleThreadExecutor(ThreadFactories.named((String)"prebaker").type(ThreadFactories.Type.DAEMON).build());
        this.state = PreBakeState.NOTSTARTED;
        this.batch = batch;
        this.config = config;
        this.webResourceIntegration = webResourceIntegration;
        this.webResourceAssemblerFactory = webResourceAssemblerFactory;
        this.resourceCollector = resourceCollector;
    }

    public void start(WebResourceCrawler ... crawlers) {
        this.start(Arrays.asList(crawlers));
    }

    public void start(List<WebResourceCrawler> crawlers) {
        this.pool.execute(new DiscoveryTask(this, this.batch, crawlers, this.resourceCollector));
    }

    public PreBakeState getState() {
        this.readState.lock();
        try {
            PreBakeState preBakeState = this.state;
            return preBakeState;
        }
        finally {
            this.readState.unlock();
        }
    }

    public boolean setState(PreBakeState newState) {
        this.writeState.lock();
        try {
            if (this.state == newState) {
                boolean bl = false;
                return bl;
            }
            if (PreBakeState.CANCELLED == newState) {
                ConcurrentUtil.stopExecutor(this.pool, 200L);
            }
            this.state = newState;
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeState.unlock();
        }
    }

    public boolean cancel() {
        return this.setState(PreBakeState.CANCELLED);
    }

    public WebResourceBatch getBatch() {
        return this.batch;
    }

    public File getBundleDir() {
        return this.webResourceIntegration.getTemporaryDirectory();
    }

    public PrebakeWebResourceAssemblerFactory getWebResourceAssemblerFactory() {
        return this.webResourceAssemblerFactory;
    }

    protected URI toURI(String uriString) {
        String absoluteBaseUrl = this.webResourceIntegration.getBaseUrl(UrlMode.ABSOLUTE);
        String relativeBaseUrl = this.webResourceIntegration.getBaseUrl(UrlMode.RELATIVE);
        if (uriString.startsWith(absoluteBaseUrl)) {
            return URI.create(uriString);
        }
        if (uriString.startsWith(relativeBaseUrl)) {
            return URI.create(absoluteBaseUrl.replace(relativeBaseUrl, "") + uriString);
        }
        return URI.create(absoluteBaseUrl + uriString);
    }

    protected String relativeUrl(String uriString) {
        String baseUrl = this.webResourceIntegration.getBaseUrl();
        if (uriString.contains(baseUrl)) {
            return uriString.replace(baseUrl, "");
        }
        return uriString;
    }

    public boolean isCSSPrebakingEnabled() {
        return this.config.isCSSPrebakingEnabled();
    }
}

