/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webresource.plugin.prebake.discovery;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.webresource.api.assembler.AssembledResources;
import com.atlassian.webresource.api.assembler.WebResource;
import com.atlassian.webresource.api.assembler.WebResourceSet;
import com.atlassian.webresource.api.assembler.resource.PluginCssResource;
import com.atlassian.webresource.api.assembler.resource.PluginJsResource;
import com.atlassian.webresource.api.assembler.resource.PluginUrlResource;
import com.atlassian.webresource.plugin.prebake.resources.PluginResource;
import com.atlassian.webresource.plugin.prebake.resources.Resource;
import java.util.Collection;
import java.util.Set;

@ExperimentalApi
public interface WebResourceCrawler {
    public Set<Resource> get();

    default public void crawlAssembledResource(AssembledResources source, Collection<Resource> destination) {
        WebResourceSet webResourceSet;
        do {
            webResourceSet = source.pollIncludedResources();
            for (WebResource resource : webResourceSet.getResources()) {
                if (!(resource instanceof PluginJsResource) && !(resource instanceof PluginCssResource)) continue;
                PluginResource pr = new PluginResource((PluginUrlResource)resource);
                destination.add(pr);
            }
        } while (!webResourceSet.isComplete());
    }
}

