/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webresource.plugin.prebake.discovery;

import com.atlassian.plugin.webresource.impl.snapshot.RootPage;
import com.atlassian.plugin.webresource.prebake.PrebakeWebResourceAssemblerFactory;
import com.atlassian.webresource.api.assembler.WebResourceAssembler;
import com.atlassian.webresource.api.prebake.Coordinate;
import com.atlassian.webresource.api.prebake.Dimensions;
import com.atlassian.webresource.plugin.prebake.discovery.WebResourceCrawler;
import com.atlassian.webresource.plugin.prebake.resources.Resource;
import java.util.LinkedHashSet;
import java.util.Set;

public final class RootPageCrawler
implements WebResourceCrawler {
    private final PrebakeWebResourceAssemblerFactory assemblerFactory;
    private final Iterable<RootPage> rootPages;

    public RootPageCrawler(PrebakeWebResourceAssemblerFactory assemblerFactory, Iterable<RootPage> rootPages) {
        this.rootPages = rootPages;
        this.assemblerFactory = assemblerFactory;
    }

    @Override
    public Set<Resource> get() {
        LinkedHashSet<Resource> resources = new LinkedHashSet<Resource>();
        Dimensions dims = this.assemblerFactory.computeDimensions();
        for (RootPage rp : this.rootPages) {
            dims.cartesianProduct().forEach(coord -> {
                WebResourceAssembler assembler = this.createAssembler(rp, (Coordinate)coord, this.assemblerFactory);
                this.crawlAssembledResource(assembler.assembled(), resources);
            });
        }
        return resources;
    }

    private WebResourceAssembler createAssembler(RootPage page, Coordinate coord, PrebakeWebResourceAssemblerFactory fct) {
        return fct.create().withCoordinate(coord).includePage(page.getWebResource().getKey()).build();
    }
}

