
WRM.define("wrm/builder", function() {

    var Builder = function(contextPath) {
        this.patterns = {
            js: {
                superBatch: new RegExp("^" + contextPath + "/s/.*/_/download/superbatch/js/batch.js.*$"),
                contextBatch: new RegExp("^" + contextPath + "/s/.*/_/download/contextbatch/js/(.*)/batch.js$"),
                resourceBatch: new RegExp("^" + contextPath + "/s/.*/_/download/batch/(.*)/(.*).js$"),
                noBatch: new RegExp("^" + contextPath + "/s/.*/_/download/resources/(.*)/(.*).js$")
            },
            css: {
                superBatch: new RegExp("^" + contextPath + "/s/.*/_/download/superbatch/css/batch.css$"),
                contextBatch: new RegExp("^" + contextPath + "/s/.*/_/download/contextbatch/css/(.*)/batch.css$"),
                resourceBatch: new RegExp("^" + contextPath + "/s/.*/_/download/batch/(.*)/(.*).css$"),
                noBatch: new RegExp("^" + contextPath + "/s/.*/_/download/resources/(.*)/(.*).css$")
            }
        };
    };
    Builder.prototype = {
        // Builds a list of loaded modules and contexts on the page
        initialize: function(container) {
            var i,
                scripts = container.getElementsByTagName("script"),
                links = container.getElementsByTagName("link"),
                loadedResources = {
                    superBatch: false,
                    modules: [],
                    contexts: []
                };

            for (i = 0; i < scripts.length; ++i) {
                var script = scripts[i];
                if (script.getAttribute("src")) {
                    this._inspectMatches(script.getAttribute("src"), this.patterns.js, loadedResources);
                }
            }

            for (i = 0; i < links.length; ++i) {
                var link = links[i];
                if (link.getAttribute("href")) {
                    this._inspectMatches(link.getAttribute("href"), this.patterns.css, loadedResources);
                }
            }

            return loadedResources;
        },
        getModulesAndContextsFromScriptUrl: function(url) {
            var loadedResources = {
                superBatch: false,
                modules: [],
                contexts: []
            };
            this._inspectMatches(url, this.patterns.js, loadedResources);
            return loadedResources;
        },
        _inspectMatches: function(url, patterns, loadedResources) {
            var match;
            match = url.match(patterns.superBatch);
            if (match) {
                loadedResources.superBatch = true;
                return;
            }
            match = url.match(patterns.contextBatch);
            if (match) {
                var matches = match[1].split(",");
                for (var i = 0; i < matches.length; ++i) {
                    this._addToLoadedList(loadedResources.contexts, matches[i]);
                }
                return;
            }
            match = url.match(patterns.resourceBatch);
            if (match) {
                this._addToLoadedList(loadedResources.modules, match[1]);
                return;
            }
            match = url.match(patterns.noBatch);
            if (match) {
                this._addToLoadedList(loadedResources.modules, match[1]);
                return;
            }
        },
        _addToLoadedList: function(loadedList, key) {
            // indexOf doesn't exist in IE8 and we can't assume underscore will be on the page, so do it the dirty way
            for (var i = 0; i < loadedList.length; ++i) {
                if (loadedList[i] === key) {
                    return;
                }
            }
            loadedList.push(key);
        }
    };

    return Builder;
});

