(function() {
    if (!window.WRM) {
        window.WRM = {};
    }

    var parsedDataMap = {};

    function parseData(unparsedData) {
        if (!unparsedData) {
            return unparsedData;
        }
        return JSON.parse(unparsedData);
    }

    // This is extremely defensive, but we use Object.prototype.hasOwnProperty as developers could include
    // a piece of data with key "hasOwnProperty"
    function _hasOwnProperty(o, key) {
        return Object.prototype.hasOwnProperty.call(o, key);
    }

    WRM.data = function(key) {
        // Lazily parses JSON data from WRM._unparsedData
        if (!_hasOwnProperty(parsedDataMap, key)) {
            if (WRM._unparsedData && _hasOwnProperty(WRM._unparsedData, key)) {
                var unparsedData = WRM._unparsedData[key];
                try {
                    parsedDataMap[key] = parseData(unparsedData);
                    WRM._unparsedData[key] = undefined; // purge from unparsed data map
                }
                catch (e) {
                    console && console.log && console.log("JSON Error parsing data with key " + key + ": " + e);
                }
            }
            else {
                parsedDataMap[key] = null;
            }
        }
        return parsedDataMap[key];
    };
}());